/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.upsert;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.UpsertType;

public class Upsert
implements Statement {
    private Table table;
    private ExpressionList<Column> columns;
    private ExpressionList<?> expressions;
    private Select select;
    private List<UpdateSet> updateSets;
    private List<UpdateSet> duplicateUpdateSets;
    private UpsertType upsertType = UpsertType.UPSERT;
    private boolean isUsingInto;

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public Upsert setUpdateSets(List<UpdateSet> list) {
        this.updateSets = list;
        return this;
    }

    public List<UpdateSet> getDuplicateUpdateSets() {
        return this.duplicateUpdateSets;
    }

    public Upsert setDuplicateUpdateSets(List<UpdateSet> list) {
        this.duplicateUpdateSets = list;
        return this;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public UpsertType getUpsertType() {
        return this.upsertType;
    }

    public void setUpsertType(UpsertType upsertType) {
        this.upsertType = upsertType;
    }

    public Upsert withUpsertType(UpsertType upsertType) {
        this.setUpsertType(upsertType);
        return this;
    }

    public boolean isUsingInto() {
        return this.isUsingInto;
    }

    public void setUsingInto(boolean bl2) {
        this.isUsingInto = bl2;
    }

    public Upsert withUsingInto(boolean bl2) {
        this.setUsingInto(bl2);
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> expressionList) {
        this.columns = expressionList;
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ExpressionList expressionList) {
        this.expressions = expressionList;
    }

    @Deprecated
    public ExpressionList<?> getSetExpressions() {
        return this.expressions;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Values getValues() {
        return this.select.getValues();
    }

    public PlainSelect getPlainSelect() {
        return this.select.getPlainSelect();
    }

    public SetOperationList getSetOperationList() {
        return this.select.getSetOperationList();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.upsertType) {
            case REPLACE: 
            case REPLACE_SET: {
                stringBuilder.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                stringBuilder.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                stringBuilder.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                stringBuilder.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                stringBuilder.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                stringBuilder.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                stringBuilder.append("UPSERT ");
            }
        }
        if (this.isUsingInto) {
            stringBuilder.append("INTO ");
        }
        stringBuilder.append(this.table).append(" ");
        if (this.updateSets != null) {
            stringBuilder.append("SET ");
            UpdateSet.appendUpdateSetsTo(stringBuilder, this.updateSets);
        } else {
            if (this.columns != null) {
                stringBuilder.append(this.columns).append(" ");
            }
            if (this.select != null) {
                stringBuilder.append(this.select);
            }
        }
        if (this.duplicateUpdateSets != null) {
            stringBuilder.append(" ON DUPLICATE KEY UPDATE ");
            UpdateSet.appendUpdateSetsTo(stringBuilder, this.duplicateUpdateSets);
        }
        return stringBuilder.toString();
    }

    public Upsert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Upsert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Upsert withColumns(ExpressionList<Column> expressionList) {
        this.setColumns(expressionList);
        return this;
    }

    public Upsert withExpressions(ExpressionList expressionList) {
        this.setExpressions(expressionList);
        return this;
    }

    public Upsert addColumns(Column ... columnArray) {
        return this.addColumns(Arrays.asList(columnArray));
    }

    public Upsert addColumns(Collection<? extends Column> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        expressionList.addAll(collection);
        return this.withColumns(expressionList);
    }
}

