/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.AutoRefreshOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.TemporaryOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SelectDeParser;

public class CreateViewDeParser
extends AbstractDeParser<CreateView> {
    private final SelectVisitor selectVisitor;

    public CreateViewDeParser(StringBuilder object) {
        super((StringBuilder)object);
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer((StringBuilder)object);
        object = new ExpressionDeParser(selectDeParser, (StringBuilder)object);
        selectDeParser.setExpressionVisitor((ExpressionVisitor)object);
        this.selectVisitor = selectDeParser;
    }

    public CreateViewDeParser(StringBuilder stringBuilder, SelectVisitor selectVisitor) {
        super(stringBuilder);
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(CreateView createView) {
        this.buffer.append("CREATE ");
        if (createView.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        switch (createView.getForce()) {
            case FORCE: {
                this.buffer.append("FORCE ");
                break;
            }
            case NO_FORCE: {
                this.buffer.append("NO FORCE ");
            }
        }
        if (createView.getTemporary() != TemporaryOption.NONE) {
            this.buffer.append(createView.getTemporary().name()).append(" ");
        }
        if (createView.isMaterialized()) {
            this.buffer.append("MATERIALIZED ");
        }
        this.buffer.append("VIEW ").append(createView.getView().getFullyQualifiedName());
        if (createView.isIfNotExists()) {
            this.buffer.append(" IF NOT EXISTS");
        }
        if (createView.getAutoRefresh() != AutoRefreshOption.NONE) {
            this.buffer.append(" AUTO REFRESH ").append(createView.getAutoRefresh().name());
        }
        if (createView.getColumnNames() != null) {
            this.buffer.append(PlainSelect.getStringList(createView.getColumnNames(), true, true));
        }
        this.buffer.append(" AS ");
        createView.getSelect().accept(this.selectVisitor);
        if (createView.isWithReadOnly()) {
            this.buffer.append(" WITH READ ONLY");
        }
    }
}

