/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.Insert;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class InsertDeParser
extends AbstractDeParser<Insert> {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public InsertDeParser() {
        super(new StringBuilder());
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Insert insert) {
        Iterator<WithItem> iterator;
        if (insert.getWithItemsList() != null && !insert.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            iterator = insert.getWithItemsList().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.selectVisitor);
                if (iterator.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.buffer.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append("INTO ");
        this.buffer.append(insert.getTable().toString());
        if (insert.getColumns() != null) {
            this.buffer.append(" (");
            iterator = insert.getColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)((Object)iterator.next());
                this.buffer.append(column.getColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        if (insert.getOutputClause() != null) {
            this.buffer.append(insert.getOutputClause().toString());
        }
        if (insert.getSelect() != null) {
            this.buffer.append(" ");
            insert.getSelect().accept(this.selectVisitor);
        }
        if (insert.getSetUpdateSets() != null) {
            this.buffer.append(" SET ");
            InsertDeParser.deparseUpdateSets(insert.getSetUpdateSets(), this.buffer, this.expressionVisitor);
        }
        if (insert.getDuplicateUpdateSets() != null) {
            this.buffer.append(" ON DUPLICATE KEY UPDATE ");
            InsertDeParser.deparseUpdateSets(insert.getDuplicateUpdateSets(), this.buffer, this.expressionVisitor);
        }
        if (insert.getConflictAction() != null) {
            this.buffer.append(" ON CONFLICT");
            if (insert.getConflictTarget() != null) {
                insert.getConflictTarget().appendTo(this.buffer);
            }
            insert.getConflictAction().appendTo(this.buffer);
        }
        if (insert.getReturningClause() != null) {
            insert.getReturningClause().appendTo(this.buffer);
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

