/*
 * Decompiled with CFR 0.152.
 */
package org.mengyun.tcctransaction.api;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mengyun.tcctransaction.api.ParticipantStatus;
import org.mengyun.tcctransaction.api.TransactionStatus;
import org.mengyun.tcctransaction.api.Xid;

public class TransactionContext
implements Serializable {
    private static final long serialVersionUID = -8199390103169700387L;
    private Xid xid;
    private Xid rootXid;
    private String rootDomain;
    private TransactionStatus status = TransactionStatus.TRYING;
    private ParticipantStatus participantStatus = ParticipantStatus.TRYING;
    private Map<String, String> attachments = new ConcurrentHashMap<String, String>();

    public TransactionContext() {
    }

    public TransactionContext(String rootDomain, Xid rootXid, Xid xid, TransactionStatus status) {
        this(rootDomain, rootXid, xid, status, ParticipantStatus.TRYING);
    }

    public TransactionContext(String rootDomain, Xid rootXid, Xid xid, TransactionStatus status, ParticipantStatus participantStatus) {
        this.rootDomain = rootDomain;
        this.rootXid = rootXid;
        this.xid = xid;
        this.status = status;
        this.participantStatus = participantStatus;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void setXid(Xid xid) {
        this.xid = xid;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, String> attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            this.attachments.putAll(attachments);
        }
    }

    public String getRootDomain() {
        return this.rootDomain;
    }

    public void setRootDomain(String rootDomain) {
        this.rootDomain = rootDomain;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransactionStatus status) {
        this.status = status;
    }

    public ParticipantStatus getParticipantStatus() {
        return this.participantStatus;
    }

    public void setParticipantStatus(ParticipantStatus participantStatus) {
        this.participantStatus = participantStatus;
    }

    public Xid getRootXid() {
        return this.rootXid;
    }

    public void setRootXid(Xid rootXid) {
        this.rootXid = rootXid;
    }
}

