/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beanutils;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessorConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final PropertyStyle mPropertyStyle;

    public BeanUtilsBindingProcessor() {
        this(new BeanUtilsBindingProcessorConfig());
    }

    public BeanUtilsBindingProcessor(BeanUtilsBindingProcessorConfig config) {
        this.mPropertyStyle = config.getPropertyStyle();
    }

    public void onStartBuild(SwingMetawidget metawidget) {
        metawidget.putClientProperty(BeanUtilsBindingProcessor.class, null);
    }

    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        JComponent componentToBind = component;
        if (componentToBind instanceof JScrollPane) {
            componentToBind = (JComponent)((JScrollPane)componentToBind).getViewport().getView();
        }
        if (componentToBind instanceof SwingMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)component);
            return component;
        }
        String componentProperty = metawidget.getValueProperty((Component)componentToBind);
        if (componentProperty == null) {
            return component;
        }
        String path = metawidget.getPath();
        if ("property".equals(elementName)) {
            path = path + '/' + attributes.get("name");
        }
        try {
            PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath((String)path, (char)'/');
            Object sourceValue = this.mPropertyStyle.traverse(metawidget.getToInspect(), typeAndNames.getType(), false, typeAndNames.getNamesAsArray()).getValue();
            String names = typeAndNames.getNames().replace('/', '.');
            SavedBinding binding = new SavedBinding(componentToBind, componentProperty, names, "true".equals(attributes.get("no-setter")));
            this.saveValueToWidget(binding, sourceValue);
            State state = this.getState(metawidget);
            if (state.bindings == null) {
                state.bindings = CollectionUtils.newHashSet();
            }
            state.bindings.add(binding);
        }
        catch (Exception e) {
            throw WidgetProcessorException.newException((Throwable)e);
        }
        return component;
    }

    public void rebind(Object toRebind, SwingMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding binding : state.bindings) {
                    String names = binding.getNames();
                    ValueAndDeclaredType valueAndDeclaredType = this.mPropertyStyle.traverse(toRebind, toRebind.getClass().getName(), false, names.split("\\."));
                    if (valueAndDeclaredType.getDeclaredType() == null) {
                        throw WidgetProcessorException.newException((String)("Property '" + names + "' has no getter"));
                    }
                    this.saveValueToWidget(binding, valueAndDeclaredType.getValue());
                }
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException((Throwable)e);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, nestedMetawidget);
            }
        }
    }

    public void save(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding binding : state.bindings) {
                    if (!binding.isSettable()) continue;
                    Object componentValue = this.retrieveValueFromWidget(binding);
                    this.saveValueToObject(metawidget, binding.getNames(), componentValue);
                }
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException((Throwable)e);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.save(nestedMetawidget);
            }
        }
    }

    public Object convertFromString(String value, Class<?> expectedType) {
        return ConvertUtils.convert((String)value, expectedType);
    }

    public void onEndBuild(SwingMetawidget metawidget) {
    }

    protected void saveValueToObject(SwingMetawidget metawidget, String names, Object componentValue) throws Exception {
        Object source = metawidget.getToInspect();
        String[] namesAsArray = names.split("\\.");
        Object parent = this.mPropertyStyle.traverse(source, source.getClass().getName(), true, namesAsArray).getValue();
        if (parent == null) {
            return;
        }
        Class<?> parentClass = parent.getClass();
        String lastName = namesAsArray[namesAsArray.length - 1];
        Property property = (Property)this.mPropertyStyle.getProperties(parentClass.getName()).get(lastName);
        Object convertedValue = ConvertUtils.convert((Object)componentValue, (Class)ClassUtils.niceForName((String)property.getType()));
        property.write(parent, convertedValue);
    }

    protected Object retrieveValueFromWidget(SavedBinding binding) throws Exception {
        return PropertyUtils.getProperty((Object)binding.getComponent(), (String)binding.getComponentProperty());
    }

    protected void saveValueToWidget(SavedBinding binding, Object sourceValue) throws Exception {
        BeanUtils.setProperty((Object)binding.getComponent(), (String)binding.getComponentProperty(), (Object)sourceValue);
    }

    private State getState(SwingMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(BeanUtilsBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(BeanUtilsBindingProcessor.class, (Object)state);
        }
        return state;
    }

    static class SavedBinding {
        private Component mComponent;
        private String mComponentProperty;
        private String mNames;
        private boolean mNoSetter;

        public SavedBinding(Component component, String componentProperty, String names, boolean noSetter) {
            this.mComponent = component;
            this.mComponentProperty = componentProperty;
            this.mNames = names;
            this.mNoSetter = noSetter;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getComponentProperty() {
            return this.mComponentProperty;
        }

        public String getNames() {
            return this.mNames;
        }

        public boolean isSettable() {
            return !this.mNoSetter;
        }
    }

    static class State {
        Set<SavedBinding> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

