/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.metawidget.inspector.faces.UiFacesAjax;
import org.metawidget.inspector.faces.UiFacesComponent;
import org.metawidget.inspector.faces.UiFacesConverter;
import org.metawidget.inspector.faces.UiFacesDateTimeConverter;
import org.metawidget.inspector.faces.UiFacesLookup;
import org.metawidget.inspector.faces.UiFacesNumberConverter;
import org.metawidget.inspector.faces.UiFacesSuggest;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesAnnotationInspector
extends BaseObjectInspector {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("((#|\\$)\\{)(.*)(\\})");

    public FacesAnnotationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public FacesAnnotationInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiFacesDateTimeConverter uiFacesDateTimeConverter;
        UiFacesNumberConverter uiFacesNumberConverter;
        UiFacesConverter uiFacesConverter;
        UiFacesAjax uiFacesAjax;
        UiFacesComponent uiFacesComponent;
        Object object;
        HashMap hashMap = CollectionUtils.newHashMap();
        UiFacesLookup uiFacesLookup = (UiFacesLookup)property.getAnnotation(UiFacesLookup.class);
        if (uiFacesLookup != null) {
            this.putExpression(hashMap, "faces-lookup", uiFacesLookup.value());
            object = uiFacesLookup.var();
            if (!"".equals(object)) {
                hashMap.put("faces-lookup-var", object);
            }
            this.putExpression(hashMap, "faces-lookup-item-value", uiFacesLookup.itemValue());
            this.putExpression(hashMap, "faces-lookup-item-label", uiFacesLookup.itemLabel());
        }
        if ((object = (UiFacesSuggest)property.getAnnotation(UiFacesSuggest.class)) != null) {
            this.putExpression(hashMap, "faces-suggest", object.value());
        }
        if ((uiFacesComponent = (UiFacesComponent)property.getAnnotation(UiFacesComponent.class)) != null) {
            hashMap.put("faces-component", uiFacesComponent.value());
        }
        if ((uiFacesAjax = (UiFacesAjax)property.getAnnotation(UiFacesAjax.class)) != null) {
            hashMap.put("faces-ajax-event", uiFacesAjax.event());
            this.putExpression(hashMap, "faces-ajax-action", uiFacesAjax.action());
        }
        if ((uiFacesConverter = (UiFacesConverter)property.getAnnotation(UiFacesConverter.class)) != null) {
            hashMap.put("faces-converter", uiFacesConverter.value());
        }
        if ((uiFacesNumberConverter = (UiFacesNumberConverter)property.getAnnotation(UiFacesNumberConverter.class)) != null) {
            if (!"".equals(uiFacesNumberConverter.currencyCode())) {
                hashMap.put("currency-code", uiFacesNumberConverter.currencyCode());
            }
            if (!"".equals(uiFacesNumberConverter.currencySymbol())) {
                hashMap.put("currency-symbol", uiFacesNumberConverter.currencySymbol());
            }
            if (uiFacesNumberConverter.groupingUsed()) {
                hashMap.put("number-uses-grouping-separators", "true");
            }
            if (uiFacesNumberConverter.minIntegerDigits() != -1) {
                hashMap.put("minimum-integer-digits", String.valueOf(uiFacesNumberConverter.minIntegerDigits()));
            }
            if (uiFacesNumberConverter.maxIntegerDigits() != -1) {
                hashMap.put("maximum-integer-digits", String.valueOf(uiFacesNumberConverter.maxIntegerDigits()));
            }
            if (uiFacesNumberConverter.minFractionDigits() != -1) {
                hashMap.put("minimum-fractional-digits", String.valueOf(uiFacesNumberConverter.minFractionDigits()));
            }
            if (uiFacesNumberConverter.maxFractionDigits() != -1) {
                hashMap.put("maximum-fractional-digits", String.valueOf(uiFacesNumberConverter.maxFractionDigits()));
            }
            if (!"".equals(uiFacesNumberConverter.locale())) {
                hashMap.put("locale", uiFacesNumberConverter.locale());
            }
            if (!"".equals(uiFacesNumberConverter.pattern())) {
                hashMap.put("number-pattern", uiFacesNumberConverter.pattern());
            }
            if (!"".equals(uiFacesNumberConverter.type())) {
                hashMap.put("number-type", uiFacesNumberConverter.type());
            }
        }
        if ((uiFacesDateTimeConverter = (UiFacesDateTimeConverter)property.getAnnotation(UiFacesDateTimeConverter.class)) != null) {
            if (!"".equals(uiFacesDateTimeConverter.dateStyle())) {
                hashMap.put("date-style", uiFacesDateTimeConverter.dateStyle());
            }
            if (!"".equals(uiFacesDateTimeConverter.locale())) {
                hashMap.put("locale", uiFacesDateTimeConverter.locale());
            }
            if (!"".equals(uiFacesDateTimeConverter.pattern())) {
                hashMap.put("datetime-pattern", uiFacesDateTimeConverter.pattern());
            }
            if (!"".equals(uiFacesDateTimeConverter.timeStyle())) {
                hashMap.put("time-style", uiFacesDateTimeConverter.timeStyle());
            }
            if (!"".equals(uiFacesDateTimeConverter.timeZone())) {
                hashMap.put("time-zone", uiFacesDateTimeConverter.timeZone());
            }
            if (!"".equals(uiFacesDateTimeConverter.type())) {
                hashMap.put("datetime-type", uiFacesDateTimeConverter.type());
            }
        }
        return hashMap;
    }

    private void putExpression(Map<String, String> map, String string, String string2) {
        if ("".equals(string2)) {
            return;
        }
        if (!this.isExpression(string2)) {
            throw InspectorException.newException((String)("Expression '" + string2 + "' (for '" + string + "') is not of the form #{...}"));
        }
        map.put(string, string2);
    }

    private boolean isExpression(String string) {
        return PATTERN_EXPRESSION.matcher(string).matches();
    }
}

