/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.ui.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class FlexTableLayoutConfig {
    private int mNumberOfColumns = 1;
    private String mTableStyleName;
    private String[] mColumnStyleNames;
    private String mFooterStyleName;

    public FlexTableLayoutConfig setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns < 0) {
            throw LayoutException.newException((String)"numberOfColumns must be >= 0");
        }
        this.mNumberOfColumns = numberOfColumns;
        return this;
    }

    public FlexTableLayoutConfig setTableStyleName(String tableStyleName) {
        this.mTableStyleName = tableStyleName;
        return this;
    }

    public FlexTableLayoutConfig setColumnStyleNames(String ... columnStyleNames) {
        this.mColumnStyleNames = columnStyleNames;
        return this;
    }

    public FlexTableLayoutConfig setFooterStyleName(String footerStyleName) {
        this.mFooterStyleName = footerStyleName;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals((Object)this, (Object)that)) {
            return false;
        }
        if (this.mNumberOfColumns != ((FlexTableLayoutConfig)that).mNumberOfColumns) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mTableStyleName, (Object)((FlexTableLayoutConfig)that).mTableStyleName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mColumnStyleNames, (Object)((FlexTableLayoutConfig)that).mColumnStyleNames)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.mFooterStyleName, (Object)((FlexTableLayoutConfig)that).mFooterStyleName);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.mNumberOfColumns;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mTableStyleName);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mColumnStyleNames);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mFooterStyleName);
        return hashCode;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected String getTableStyleName() {
        return this.mTableStyleName;
    }

    protected String[] getColumnStyleNames() {
        return this.mColumnStyleNames;
    }

    protected String getFooterStyleName() {
        return this.mFooterStyleName;
    }
}

