/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.json.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.json.JsonInspector;
import org.metawidget.inspector.json.JsonInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JsonSchemaInspector
extends JsonInspector {
    private static final String PROPERTIES = "properties";

    public JsonSchemaInspector(JsonInspectorConfig config) {
        super(config);
    }

    public Element inspectAsDom(Object toInspect, String type, String ... names) {
        JsonObject root = this.getRoot();
        for (String name : names) {
            if (!root.has(PROPERTIES)) {
                return null;
            }
            if (!(root = root.getAsJsonObject(PROPERTIES)).has(name)) {
                return null;
            }
            root = root.getAsJsonObject(name);
        }
        Document document = XmlUtils.newDocument();
        Element documentRoot = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
        documentRoot.setAttribute("version", "1.0");
        document.appendChild(documentRoot);
        Element entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        entity.setAttribute("type", type);
        documentRoot.appendChild(entity);
        if (names.length > 0) {
            entity.setAttribute("name", names[names.length - 1]);
        }
        this.writeJsonAttributesAsDom(entity, root);
        if (root.has(PROPERTIES)) {
            root = root.getAsJsonObject(PROPERTIES);
            for (Map.Entry entry : root.entrySet()) {
                String name = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if (!element.isJsonObject()) {
                    throw InspectorException.newException((String)("'" + name + "' is not a " + JsonObject.class));
                }
                JsonObject property = element.getAsJsonObject();
                Element child = document.createElementNS("http://metawidget.org/inspection-result", "property");
                child.setAttribute("name", name);
                this.writeJsonAttributesAsDom(child, property);
                entity.appendChild(child);
            }
        }
        return documentRoot;
    }

    private void writeJsonAttributesAsDom(Element element, JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            String name = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonArray()) {
                ArrayList array = CollectionUtils.newArrayList();
                Iterator i = jsonElement.getAsJsonArray().iterator();
                while (i.hasNext()) {
                    array.add(((JsonElement)i.next()).getAsString());
                }
                element.setAttribute(name, CollectionUtils.toString((Collection)array));
                continue;
            }
            if (!jsonElement.isJsonPrimitive()) continue;
            element.setAttribute(name, jsonElement.getAsString());
        }
    }
}

