/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import junit.framework.TestCase;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.propertytype.PropertyTypeInspector;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.LiteralTag;
import org.metawidget.jsp.tagext.StubTag;
import org.metawidget.jsp.tagext.html.HtmlMetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.jsp.tagext.html.widgetbuilder.ReadOnlyWidgetBuilder;
import org.metawidget.jsp.tagext.layout.SimpleLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.util.CollectionUtils;

public class ReadOnlyWidgetBuilderTest
extends TestCase {
    public void testWidgetBuilder() throws Exception {
        ReadOnlyWidgetBuilder widgetBuilder = new ReadOnlyWidgetBuilder();
        HtmlMetawidgetTag dummyMetawidget = new HtmlMetawidgetTag();
        HashMap attributes = CollectionUtils.newHashMap();
        attributes.put("read-only", "true");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("hidden", "true");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof HtmlStubTag));
        attributes.remove("hidden");
        attributes.put("masked", "true");
        LiteralTag literalTag = (LiteralTag)widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget);
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)"".equals(JspUtils.writeTag((PageContext)dummyMetawidget.getPageContext(), (Tag)literalTag, (Tag)dummyMetawidget)));
        attributes.remove("masked");
        attributes.put("lookup", "foo");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("lookup-labels", "Foo");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.remove("lookup-labels");
        attributes.remove("lookup");
        attributes.put("jsp-lookup", "${foo.bar}");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.remove("jsp-lookup");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("type", Integer.TYPE.getName());
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("type", Integer.class.getName());
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("type", Date.class.getName());
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.put("type", String[].class.getName());
        dummyMetawidget.setInspector((Inspector)new PropertyTypeInspector());
        ReadOnlyWidgetBuilderTest.assertEquals(null, (Object)widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget));
        attributes.put("type", List.class.getName());
        attributes.put("name", "bar");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof StubTag));
        attributes.put("type", Set.class.getName());
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof StubTag));
        attributes.put("type", Color.class.getName());
        ReadOnlyWidgetBuilderTest.assertEquals(null, (Object)widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget));
        attributes.put("dont-expand", "true");
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
        attributes.remove("dont-expand");
        dummyMetawidget.setLayout((Layout)new SimpleLayout());
        ReadOnlyWidgetBuilderTest.assertTrue((boolean)(widgetBuilder.buildWidget("property", (Map)attributes, (Object)dummyMetawidget) instanceof LiteralTag));
    }
}

