/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.loadtest.sip11;

import gov.nist.javax.sip.Utils;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;

public abstract class SimpleCallSetupTerminatedByServerWithDialogsTestSbb
implements Sbb {
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sipFactoryProvider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private TimerFacility timerFacility;
    private static ContactHeader contactHeader;
    private SbbContext sbbContext;

    private ContactHeader getContactHeader() throws ParseException {
        if (contactHeader == null) {
            ListeningPoint listeningPoint = this.sipFactoryProvider.getListeningPoint("udp");
            Address address = this.addressFactory.createAddress("Mobicents SIP AS <sip:" + listeningPoint.getIPAddress() + ">");
            ((SipURI)address.getURI()).setPort(listeningPoint.getPort());
            contactHeader = this.headerFactory.createContactHeader(address);
        }
        return contactHeader;
    }

    public void onInviteEvent(RequestEvent requestEvent, ActivityContextInterface aci) {
        try {
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            DialogActivity dialog = (DialogActivity)this.sipFactoryProvider.getNewDialog((Transaction)serverTransaction);
            this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog).attach(this.sbbContext.getSbbLocalObject());
            Response response = this.messageFactory.createResponse(200, requestEvent.getRequest());
            response.addHeader((Header)this.getContactHeader());
            ((ToHeader)response.getHeader("To")).setTag(Utils.getInstance().generateTag());
            serverTransaction.sendResponse(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onAckEvent(RequestEvent requestEvent, ActivityContextInterface aci) {
        try {
            TimerOptions timerOptions = new TimerOptions();
            timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
            this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + 60000L, timerOptions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            DialogActivity dialog = (DialogActivity)aci.getActivity();
            Request request = dialog.createRequest("BYE");
            request.addHeader((Header)this.getContactHeader());
            ClientTransaction clientTransaction = this.sipFactoryProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipFactoryProvider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.sipFactoryProvider.getAddressFactory();
            this.headerFactory = this.sipFactoryProvider.getHeaderFactory();
            this.messageFactory = this.sipFactoryProvider.getMessageFactory();
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }
}

