/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.qa.report.sipp;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.mobicents.qa.report.sipp.OpenCsvReader;

public class Report {
    private static Logger logger;
    private static Set<String> selectedCategories;
    private static String referenceCategory;
    private static boolean allCharts;
    private static boolean singleFile;
    private static boolean printCharts;
    private static boolean bigCharts;

    private static void printInfo() {
        logger.info((Object)"Usage: java -jar 'thisFile' [options] [file1 ... fileN]");
        logger.info((Object)"Usage: If no files are specified, all .csv files in current directory are used");
        logger.info((Object)"Option: -a - ALL    - Generates charts for all the categories");
        logger.info((Object)"Option: -b - BIG    - Generates charts with 1 pixel for each elapsed second");
        logger.info((Object)"Option: -d - DEBUG  - Extra information during program execution");
        logger.info((Object)"Option: -h - HELP   - Shows this info and exits");
        logger.info((Object)"Option: -p - PRINT  - Print chart images in a subfolder");
    }

    public static void main(String[] args) {
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%c %-5p %m%n")));
        logger.setLevel(Level.INFO);
        logger.info((Object)"Sipp Report Tool starting ... ");
        for (String string : args) {
            if (!"-d".equals(string)) continue;
            logger.setLevel(Level.DEBUG);
            logger.debug((Object)"Debug level set");
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Arrays.toString(selectedCategories.toArray()));
            String s = "Arguments:_";
            for (String string : args) {
                s = s + string + "_|_";
            }
            logger.debug((Object)s);
        }
        HashSet<String> filenames = new HashSet<String>();
        for (String string : args) {
            if (string.charAt(0) != '-') {
                filenames.add(string);
                logger.debug((Object)("File to open: " + string));
                continue;
            }
            if ("-a".equals(string)) {
                allCharts = true;
                logger.info((Object)"All charts set");
                continue;
            }
            if ("-p".equals(string)) {
                printCharts = true;
                logger.info((Object)"Print chart images set");
                continue;
            }
            if ("-b".equals(string)) {
                bigCharts = true;
                logger.info((Object)"Big chart set");
                continue;
            }
            if (!"-h".equals(string) && !"--help".equals(string)) continue;
            Report.printInfo();
            return;
        }
        if (filenames.isEmpty()) {
            try {
                File[] files;
                URL url = Report.class.getProtectionDomain().getCodeSource().getLocation();
                File myDir = new File(URLDecoder.decode(url.getFile(), "UTF-8")).getAbsoluteFile().getParentFile();
                for (File file : files = myDir.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String s) {
                        return s.endsWith(".csv");
                    }
                })) {
                    filenames.add(file.getAbsolutePath());
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)"Could not get current dir");
            }
        }
        if (filenames.isEmpty()) {
            Report.printInfo();
        } else {
            if (filenames.size() == 1) {
                singleFile = true;
                logger.debug((Object)"Single file mode - set");
            }
            for (String string : filenames) {
                Report.createReports(string);
            }
            logger.info((Object)"Done. Oh yeah!");
        }
    }

    public static void createReports(String filename) {
        try {
            int referenceSize;
            OpenCsvReader csv = new OpenCsvReader(new FileReader(filename), ';', '\"');
            Object[] categories = csv.readNext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Categories read from CSV: " + Arrays.toString(categories)));
            }
            List<String[]> values = csv.readAll();
            int rows = values.size();
            csv.close();
            double[] referenceData = null;
            for (int i = 0; i < categories.length; ++i) {
                if (!referenceCategory.equals(categories[i])) continue;
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                double timeReference = timeFormat.parse(values.get(0)[i]).getTime();
                int n = 0;
                referenceData = new double[rows];
                for (String[] value : values) {
                    try {
                        referenceData[n++] = ((double)timeFormat.parse(value[i]).getTime() - timeReference) / 1000.0;
                    }
                    catch (ParseException e) {
                        logger.warn((Object)("Unexpeted parse exception for field " + (String)categories[i]), (Throwable)e);
                    }
                }
            }
            if (referenceData == null) {
                logger.error((Object)("Invalid reference category: " + referenceCategory));
                return;
            }
            LinkedHashMap<Object, DefaultXYDataset> categoryValues = new LinkedHashMap<Object, DefaultXYDataset>();
            LinkedHashMap<Object, FieldType> categoryTypes = new LinkedHashMap<Object, FieldType>();
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            for (int i = 0; i < categories.length; ++i) {
                if (!selectedCategories.contains(categories[i]) && !allCharts) {
                    logger.debug((Object)("Category " + (String)categories[i] + " does not belong to selected categories. Dropping."));
                    continue;
                }
                try {
                    Double.parseDouble(values.get(0)[i]);
                    categoryTypes.put(categories[i], FieldType.DOUBLE);
                    logger.debug((Object)("Category " + (String)categories[i] + " is of Double type (" + values.get(0)[i] + ")"));
                }
                catch (NumberFormatException nfe) {
                    try {
                        timeFormat.parse(values.get(0)[i]);
                        categoryTypes.put(categories[i], FieldType.TIME);
                        logger.debug((Object)("Category " + (String)categories[i] + " is of Time type (" + values.get(0)[i] + ")"));
                    }
                    catch (ParseException pe) {
                        try {
                            dateFormat.parse(values.get(0)[i]);
                            categoryTypes.put(categories[i], FieldType.DATE);
                            logger.warn((Object)("Date format not implemented for field " + (String)categories[i] + " (" + values.get(0)[i] + ")"));
                        }
                        catch (ParseException e) {
                            categoryTypes.put(categories[i], FieldType.INVALID);
                            logger.warn((Object)("Column " + (String)categories[i] + " is not in numeric format (" + values.get(0)[i] + "): " + e.getMessage()));
                        }
                        continue;
                    }
                }
                DefaultXYDataset dataset = new DefaultXYDataset();
                double timeReference = 0.0;
                if (categoryTypes.get(categories[i]) == FieldType.TIME) {
                    timeReference = timeFormat.parse(values.get(0)[i]).getTime();
                }
                int n = 0;
                double[] valueData = new double[rows];
                switch ((FieldType)((Object)categoryTypes.get(categories[i]))) {
                    case DOUBLE: {
                        for (String[] value : values) {
                            valueData[n++] = Double.parseDouble(value[i]);
                        }
                        break;
                    }
                    case TIME: {
                        boolean isStDev = ((String)categories[i]).contains("StDev");
                        for (String[] value : values) {
                            try {
                                double myTimeValue = ((double)timeFormat.parse(value[i]).getTime() - timeReference) / 1000.0;
                                if (isStDev && myTimeValue < 0.0) {
                                    valueData[n++] = Double.NaN;
                                    continue;
                                }
                                valueData[n++] = myTimeValue;
                            }
                            catch (ParseException e) {
                                logger.warn((Object)("Unexpeted parse exception for field " + (String)categories[i]), (Throwable)e);
                            }
                        }
                        break;
                    }
                    case DATE: {
                        break;
                    }
                }
                dataset.addSeries((Comparable)categories[i], (double[][])new double[][]{referenceData, valueData});
                categoryValues.put(categories[i], dataset);
            }
            if (categoryValues.isEmpty()) {
                logger.warn((Object)"No categories to be written to file.");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Writting categories: " + Arrays.toString(categoryValues.keySet().toArray())));
            }
            logger.info((Object)("Writting report '" + (singleFile ? "report.pdf" : filename.replaceAll(".csv", ".pdf")) + "'  ..."));
            int imageSizeX = referenceSize = bigCharts ? new Double(referenceData[referenceData.length - 1]).intValue() : 1600;
            int imageSizeY = 800;
            Document document = new Document();
            document.setPageSize(new Rectangle((float)imageSizeX, (float)imageSizeY));
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(singleFile ? "report.pdf" : filename.replaceAll(".csv", ".pdf")));
            document.open();
            for (String category : categoryValues.keySet()) {
                String title = category.replace("(P)", " (Periodic)").replace("(C)", " (Cumulative)");
                String xLabel = referenceCategory.replace("(P)", "").replace("(C)", "") + " (seconds)";
                String yLabel = category.replace("(P)", "").replace("(C)", "");
                switch ((FieldType)((Object)categoryTypes.get(category))) {
                    case DOUBLE: {
                        if (category.contains("Rate")) {
                            yLabel = yLabel + " (call/s)";
                            title = title.replace("(Cumulative)", "(Average)");
                            break;
                        }
                        if (!category.contains("(P)")) break;
                        yLabel = yLabel + " per second";
                        break;
                    }
                    case TIME: {
                        yLabel = yLabel + " (seconds)";
                        title = title.replace("(Cumulative)", "(Average)");
                        break;
                    }
                    case DATE: {
                        break;
                    }
                    case INVALID: {
                        break;
                    }
                }
                JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)((XYDataset)categoryValues.get(category)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                BufferedImage image = chart.createBufferedImage(imageSizeX, imageSizeY);
                document.add((Element)com.lowagie.text.Image.getInstance((Image)image, null));
                logger.debug((Object)("Wrote category chart " + category));
                if (!printCharts) continue;
                String newDirName = singleFile ? "charts" : filename.split("_")[1];
                KeypointPNGEncoderAdapter encoder = new KeypointPNGEncoderAdapter();
                new File(newDirName).mkdir();
                String chartFile = newDirName + File.separator + category + "Chart.png";
                encoder.encode(image, (OutputStream)new FileOutputStream(chartFile));
                logger.debug((Object)("Wrote category chart to file " + category));
            }
            document.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Unable to open file: " + filename), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)("IOException in csv file: " + filename), (Throwable)e);
        }
        catch (DocumentException e) {
            logger.warn((Object)("DocumentException: " + e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            logger.warn((Object)("ParseException: " + e.getMessage()), (Throwable)e);
        }
    }

    static {
        String[] selected;
        logger = Logger.getLogger((String)Report.class.getName());
        selectedCategories = new HashSet<String>();
        for (String category : selected = new String[]{"TargetRate", "CallRate", "IncomingCall", "CurrentCall", "SuccessfulCall", "FailedCall", "FailedMaxUDPRetrans", "FailedUnexpectedMessage", "DeadCallMsgs", "Retransmissions", "ResponseTime1", "ResponseTime1StDev", "CallLength", "CallLengthStDev"}) {
            selectedCategories.add(category);
            selectedCategories.add(category.concat("(C)"));
            selectedCategories.add(category.concat("(P)"));
        }
        referenceCategory = "ElapsedTime(C)";
        allCharts = false;
        singleFile = false;
        printCharts = false;
        bigCharts = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FieldType {
        DOUBLE,
        TIME,
        DATE,
        INVALID;

    }
}

