/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ArrayList;
import java.util.Vector;
import javax.csapi.cc.jcc.EventFilter;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidPartyException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccCallEvent;
import javax.csapi.cc.jcc.JccCallListener;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccProvider;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.DefaultFilter;
import org.mobicents.jcc.inap.JccInapProviderImpl;

public class JccCallImpl
implements JccCall {
    public static int CALL_ID_GENERATOR = 1;
    protected String callID;
    protected int direction;
    protected JccInapProviderImpl provider;
    protected int state = 1;
    protected ConcurrentReaderHashMap connections = new ConcurrentReaderHashMap();
    protected ArrayList callListeners = new ArrayList();
    protected ArrayList connectionListeners = new ArrayList();
    private Logger logger = Logger.getLogger(JccCallImpl.class);
    private JccAddress callingNumber;

    protected JccCallImpl(JccInapProviderImpl provider, JccAddress callingNumber) {
        this.provider = provider;
        this.callingNumber = callingNumber;
        this.provider.calls.put((Object)callingNumber.getName(), (Object)this);
        this.callID = Integer.toString(CALL_ID_GENERATOR++);
        this.state = 2;
    }

    public JccConnection createConnection(String targetAddress, String originatingAddress, String originalCalledAddress, String redirectingAddress) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidArgumentException, InvalidPartyException {
        return null;
    }

    protected void fireCallEvent(Vector callListeners, JccCallEvent event) {
        block8: for (int i = 0; i < callListeners.size(); ++i) {
            JccCallListener listener = (JccCallListener)callListeners.get(i);
            switch (event.getID()) {
                case 101: {
                    listener.callActive(event);
                    continue block8;
                }
                case 118: {
                    listener.callCreated(event);
                    continue block8;
                }
                case 103: {
                    listener.callEventTransmissionEnded(event);
                    continue block8;
                }
                case 102: {
                    listener.callInvalid(event);
                    continue block8;
                }
                case 112: {
                    listener.callSuperviseEnd(event);
                    continue block8;
                }
                case 111: {
                    listener.callSuperviseStart(event);
                }
            }
        }
    }

    protected void fireCallEvent(JccCallEvent event) {
    }

    public void addCallListener(JccCallListener listener) throws ResourceUnavailableException, MethodNotSupportedException {
        this.callListeners.add(listener);
    }

    public void addConnectionListener(JccConnectionListener cl, EventFilter filter) throws ResourceUnavailableException, MethodNotSupportedException {
        Object[] listener = new Object[]{cl, new DefaultFilter()};
        this.connectionListeners.add(listener);
    }

    public JccConnection[] connect(JccAddress origaddr, String dialedDigits) throws ResourceUnavailableException, PrivilegeViolationException, InvalidPartyException, InvalidStateException, MethodNotSupportedException {
        return null;
    }

    public synchronized JccConnection[] getConnections() {
        switch (this.state) {
            case 2: {
                int count = this.connections.size();
                JccConnection[] list = new JccConnection[count];
                Object[] conn = this.connections.values().toArray();
                for (int i = 0; i < count; ++i) {
                    list[i] = (JccConnection)conn[i];
                }
                return list;
            }
        }
        return null;
    }

    public JccProvider getProvider() {
        return this.provider;
    }

    public int getState() {
        return this.state;
    }

    public void release(int causeCode) throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException, InvalidArgumentException {
    }

    public void removeCallListener(JccCallListener calllistener) {
    }

    public void removeConnectionListener(JccConnectionListener cl) {
    }

    public void superviseCall(JccCallListener calllistener, double time, int treatment) throws MethodNotSupportedException {
    }

    protected synchronized void append(JccConnection connection) {
        this.connections.put((Object)connection.getAddress().getName(), (Object)connection);
        long id = ((AbstractConnection)connection).getID().getId();
        this.provider.connections.put((Object)new Long(id), (Object)connection);
    }

    protected synchronized void remove(JccConnection connection) {
        this.connections.remove((Object)connection.getAddress().getName());
        long id = ((AbstractConnection)connection).getID().getId();
        this.provider.connections.remove((Object)new Long(id));
        if (this.connections.size() == 0) {
            this.clear();
        }
    }

    protected void clear() {
        this.callListeners.clear();
        this.connectionListeners.clear();
        this.provider.calls.remove((Object)this.callingNumber.getName());
    }

    public JccConnection routeCall(String string, String string0, String string1, String string2) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidPartyException, InvalidArgumentException {
        return null;
    }

    public String toString() {
        return "(callID=" + this.callID + ")";
    }
}

