/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.csapi.cc.jcc.CallLoadControlListener;
import javax.csapi.cc.jcc.EventFilter;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidPartyException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccCallListener;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccProvider;
import javax.csapi.cc.jcc.JccProviderListener;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ProviderUnavailableException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.DefaultFilter;
import org.mobicents.jcc.inap.JccCallImpl;
import org.mobicents.jcc.inap.TCHandler;
import org.mobicents.jcc.inap.address.JccCalledPartyBCDNumber;
import org.mobicents.jcc.inap.address.JccCalledPartyNumber;
import org.mobicents.jcc.inap.address.JccCallingPartyNumber;
import org.mobicents.jcc.inap.gt.TranslationTable;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyBcdNumber;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.CallingPartyNumber;
import org.mobicents.jcc.inap.protocol.tcap.TCAbort;
import org.mobicents.jcc.inap.protocol.tcap.TCBegin;
import org.mobicents.jcc.inap.protocol.tcap.TCContinue;
import org.mobicents.jcc.inap.protocol.tcap.TCMessage;
import org.mobicents.jcc.inap.protocol.tcap.Util;
import org.mobicents.ss7.sccp.SccpAddress;
import org.mobicents.ss7.sccp.SccpListener;
import org.mobicents.ss7.sccp.SccpPeer;
import org.mobicents.ss7.sccp.SccpProvider;

public class JccInapProviderImpl
implements JccProvider,
SccpListener {
    public static final int DEFAULT_POOL_SIZE = 10;
    protected static final String name = "Java call control provider for INAP 1.1";
    protected ArrayList callListeners = new ArrayList();
    protected ArrayList connectionListeners = new ArrayList();
    private int state = 2;
    protected SccpProvider sccpProvider = null;
    protected ConcurrentReaderHashMap calls = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap connections = new ConcurrentReaderHashMap();
    private Properties properties;
    protected TranslationTable incInitialTT;
    protected TranslationTable incFinalTT;
    protected TranslationTable outInitialTT;
    protected TranslationTable outFinalTT;
    private PooledExecutor threadPool;
    private Logger logger = Logger.getLogger(JccInapProviderImpl.class);
    private Thread monitor;
    private boolean stopped = false;

    public JccInapProviderImpl(Properties properties) {
        this.properties = properties;
        try {
            String sccpProviderName = properties.getProperty("sccp.provider");
            String sccpProps = properties.getProperty("sccp.conf");
            SccpPeer sccpPeer = new SccpPeer(sccpProviderName);
            this.sccpProvider = sccpPeer.getProvider(sccpProps);
            this.sccpProvider.addSccpListener(this);
            this.logger.info((Object)"Initialized SCCP provider");
            this.incInitialTT = new TranslationTable(properties.getProperty("terminating.initial.translation"));
            this.incFinalTT = new TranslationTable(properties.getProperty("terminating.final.translation"));
            this.outInitialTT = new TranslationTable(properties.getProperty("originating.initial.translation"));
            this.outFinalTT = new TranslationTable(properties.getProperty("originating.final.translation"));
            this.logger.info((Object)"Initialized Global translation tables");
            int poolSize = 10;
            if (properties.getProperty("thread.pool.size") != null) {
                try {
                    poolSize = Integer.parseInt(properties.getProperty("thread.pool.size"));
                }
                catch (NumberFormatException e) {
                    this.logger.warn((Object)"Use default pool size", (Throwable)e);
                }
            }
            this.threadPool = new PooledExecutor(poolSize);
            this.logger.info((Object)"Initialized thread pool");
            this.state = 1;
            this.monitor = new Thread(new Monitor());
            this.monitor.start();
            this.logger.info((Object)"Started monitor");
        }
        catch (Exception e) {
            System.err.println("Could not load JccProvider " + e.getMessage());
            throw new ProviderUnavailableException(e.getMessage());
        }
    }

    public void addCallListener(JccCallListener listener) throws MethodNotSupportedException, ResourceUnavailableException {
        this.callListeners.add(listener);
    }

    public void addCallLoadControlListener(CallLoadControlListener listener) throws MethodNotSupportedException, ResourceUnavailableException {
        throw new MethodNotSupportedException("Call load controll not supported");
    }

    public void addConnectionListener(JccConnectionListener listener, EventFilter filter) throws ResourceUnavailableException, MethodNotSupportedException {
        Object[] ls = new Object[]{listener, new DefaultFilter()};
        this.connectionListeners.add(ls);
    }

    public void addProviderListener(JccProviderListener providerlistener) throws ResourceUnavailableException, MethodNotSupportedException {
        throw new MethodNotSupportedException();
    }

    public JccCall createCall() throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException {
        return null;
    }

    public EventFilter createEventFilterAddressRange(String lowAddress, String highAddress, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterAddressRegEx(String addressRegex, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterAnd(EventFilter[] filters, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterCauseCode(int causeCode, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterDestAddressRange(String lowDestAddress, String highDestAddress, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterDestAddressRegEx(String destAddressRegex, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterEventSet(int[] blockEvents, int[] notifyEvents) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterMidCallEvent(int midCallType, String midCallValue, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterMinimunCollectedAddressLength(int minimumAddressLength, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterOr(EventFilter[] filters, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterOrigAddressRange(String lowOrigAddress, String highOrigAddress, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public EventFilter createEventFilterOrigAddressRegEx(String origAddressRegex, int matchDisposition, int nomatchDisposition) throws ResourceUnavailableException, InvalidArgumentException {
        return null;
    }

    public JccAddress getAddress(String address) throws InvalidPartyException {
        return null;
    }

    public String getName() {
        return name;
    }

    public int getState() {
        return this.state;
    }

    public void removeCallListener(JccCallListener calllistener) {
    }

    public void removeCallLoadControlListener(CallLoadControlListener loadcontrollistener) {
    }

    public void removeConnectionListener(JccConnectionListener connectionlistener) {
    }

    public void removeProviderListener(JccProviderListener providerlistener) {
    }

    public void setCallLoadControl(JccAddress[] address, double duration, double[] mechanism, int[] treatment) throws MethodNotSupportedException {
    }

    public void shutdown() {
        this.callListeners.clear();
        this.connectionListeners.clear();
        this.calls.clear();
        this.connections.clear();
        this.threadPool.shutdownNow();
        this.sccpProvider.shutdown();
        this.state = 3;
    }

    public void onMessage(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, byte[] data) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        int mt = in.read() & 0xFF;
        int len = 0;
        try {
            len = Util.readLen(in);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not decode length of the TC_MESSAGE:", (Throwable)e);
            return;
        }
        byte[] buffer = new byte[len];
        try {
            in.read(buffer);
        }
        catch (IOException e) {
            // empty catch block
        }
        TCMessage tcMessage = null;
        switch (mt) {
            case 98: {
                try {
                    tcMessage = new TCBegin(buffer);
                    break;
                }
                catch (IOException e) {
                    this.logger.error((Object)"Could not decode TC_BEGIN", (Throwable)e);
                    return;
                }
            }
            case 101: {
                try {
                    tcMessage = new TCContinue(buffer);
                    break;
                }
                catch (IOException e) {
                    this.logger.error((Object)"Could not decode TC_CONTINUE", (Throwable)e);
                    return;
                }
            }
            case 103: {
                try {
                    tcMessage = new TCAbort(buffer);
                    break;
                }
                catch (IOException e) {
                    this.logger.error((Object)"Could not decode TC_ABORT", (Throwable)e);
                    return;
                }
            }
            case 100: {
                try {
                    tcMessage = new TCAbort(buffer);
                    break;
                }
                catch (IOException e) {
                    this.logger.error((Object)"Could not decode TC_END", (Throwable)e);
                    return;
                }
            }
            default: {
                this.logger.warn((Object)("Unexpected TCMessage: " + Integer.toHexString(mt) + "h"));
                return;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("--> " + tcMessage));
        }
        TCHandler handler = new TCHandler(this, calledPartyAddress, callingPartyAddress, tcMessage);
        try {
            this.threadPool.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    protected synchronized void send(SccpAddress calledParty, SccpAddress callingParty, TCMessage msg) throws IOException {
        this.sccpProvider.send(calledParty, callingParty, msg.toByteArray());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("<-- " + msg));
        }
    }

    protected JccCallImpl getCall(JccAddress callingNumber) {
        return (JccCallImpl)this.calls.get((Object)callingNumber.getName());
    }

    protected AbstractConnection getConnection(long connectionID) {
        return (AbstractConnection)this.connections.get((Object)new Long(connectionID));
    }

    protected synchronized JccAddress createAddress(CalledPartyNumber cpn) {
        return new JccCalledPartyNumber(this, cpn);
    }

    protected synchronized JccAddress createAddress(CalledPartyBcdNumber cpn) {
        return new JccCalledPartyBCDNumber(this, cpn);
    }

    protected synchronized JccAddress createAddress(CallingPartyNumber cpn) {
        return new JccCallingPartyNumber(this, cpn);
    }

    protected JccCallImpl createCall(JccAddress callingNumber) {
        return new JccCallImpl(this, callingNumber);
    }

    public synchronized CalledPartyNumber initialTranslation(CalledPartyNumber cpn) {
        try {
            return this.incInitialTT.translate(cpn);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error during initial translation", (Throwable)e);
            return cpn;
        }
    }

    public synchronized CalledPartyNumber finalTranslation(CalledPartyNumber cpn) {
        try {
            return this.incFinalTT.translate(cpn);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error during initial translation", (Throwable)e);
            return cpn;
        }
    }

    public synchronized CalledPartyNumber initialTranslation(CalledPartyBcdNumber cpn) {
        try {
            return this.outInitialTT.translate(cpn);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error during initial translation", (Throwable)e);
            return new CalledPartyNumber(cpn.getNi(), 0, 0, cpn.getAddress());
        }
    }

    public synchronized CalledPartyNumber finalTranslation(CalledPartyBcdNumber cpn) {
        try {
            return this.outFinalTT.translate(cpn);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error during final translation", (Throwable)e);
            return new CalledPartyNumber(cpn.getNi(), 0, 0, cpn.getAddress());
        }
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        public void run() {
            while (!JccInapProviderImpl.this.stopped) {
                try {
                    Thread.currentThread();
                    Thread.sleep(60000L);
                    JccInapProviderImpl.this.logger.info((Object)("active calls:" + JccInapProviderImpl.this.calls.size() + ", active connections: " + JccInapProviderImpl.this.connections.size()));
                }
                catch (InterruptedException e) {
                    JccInapProviderImpl.this.stopped = true;
                }
            }
        }
    }
}

