/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import java.util.Properties;
import java.util.StringTokenizer;
import javax.csapi.cc.jcc.JccPeer;
import javax.csapi.cc.jcc.JccProvider;
import javax.csapi.cc.jcc.ProviderUnavailableException;
import org.mobicents.jcc.inap.JccInapProviderImpl;

public class JccPeerImpl
implements JccPeer {
    private static final String name = "Java Call Control API for INAP";

    public String getName() {
        return name;
    }

    public JccProvider getProvider(String providerString) throws ProviderUnavailableException {
        String serviceName = null;
        Properties properties = new Properties();
        int pos = providerString.indexOf(59);
        if (pos < 0) {
            serviceName = providerString;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(providerString, ";");
            serviceName = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                String pair = tokenizer.nextToken();
                pos = pair.indexOf("=");
                if (pos < 0) {
                    throw new ProviderUnavailableException("Bad argument's format: " + pair);
                }
                String arg = pair.substring(0, pos).trim();
                String val = pair.substring(pos + 1, pair.length()).trim();
                properties.setProperty(arg, val);
            }
        }
        if (!serviceName.equals("<jcc-inap>")) {
            throw new ProviderUnavailableException("Not supported service: " + serviceName);
        }
        System.out.println("**** JCC: loading provider...");
        return new JccInapProviderImpl(properties);
    }

    public String[] getServices() {
        return new String[]{"jcc-inap"};
    }
}

