/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import java.io.IOException;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidPartyException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccEvent;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.MidCallData;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.ConnectionID;
import org.mobicents.jcc.inap.JccCallImpl;
import org.mobicents.jcc.inap.JccConnectionEventImpl;
import org.mobicents.jcc.inap.address.JccCalledPartyBCDNumber;
import org.mobicents.jcc.inap.address.JccCallingPartyNumber;
import org.mobicents.jcc.inap.protocol.ApplyCharging;
import org.mobicents.jcc.inap.protocol.CallInformationRequest;
import org.mobicents.jcc.inap.protocol.Connect;
import org.mobicents.jcc.inap.protocol.Continue;
import org.mobicents.jcc.inap.protocol.RequestBCSMState;
import org.mobicents.jcc.inap.protocol.parms.BCSMEvent;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.LegID;
import org.mobicents.jcc.inap.protocol.parms.RequestedInformationTypeList;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.DialoguePortion;
import org.mobicents.jcc.inap.protocol.tcap.Invoke;
import org.mobicents.jcc.inap.protocol.tcap.TCContinue;
import org.mobicents.ss7.sccp.SccpAddress;

public class OriginatingConnection
extends AbstractConnection {
    private JccCalledPartyBCDNumber destinationAddress;
    private String lastAddress;
    private String originalAddress;
    private String redirectedAddress;

    public OriginatingConnection(ConnectionID connectionID, JccCallImpl call, JccAddress address) {
        super(connectionID, call, address);
        this.logger = Logger.getLogger(OriginatingConnection.class);
    }

    public void selectRoute(String digits) throws MethodNotSupportedException, InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, InvalidPartyException {
        this.destinationAddress.setName(digits);
        if (this.isBlocked()) {
            this.resume();
        }
    }

    public void answer() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException, MethodNotSupportedException {
        throw new MethodNotSupportedException();
    }

    public void attachMedia() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException {
    }

    public void detachMedia() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException {
    }

    public String getLastAddress() {
        return null;
    }

    public String getOriginalAddress() {
        return null;
    }

    public String getDestinationAddress() {
        return this.destinationAddress == null ? null : this.destinationAddress.getName();
    }

    public JccAddress getOriginatingAddress() {
        return this.address;
    }

    public String getRedirectedAddress() {
        return null;
    }

    public void routeConnection(boolean b) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidPartyException, InvalidArgumentException {
    }

    public MidCallData getMidCallData() throws InvalidStateException, ResourceUnavailableException, MethodNotSupportedException {
        return null;
    }

    public void onAuthorizeCallAttempt() {
    }

    public void onAddressCollect() {
    }

    public void onAddressAnalyze(JccConnectionEventImpl evt) {
        this.logger.info((Object)(this + "ADDRESS_ANALYZE, " + OriginatingConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onAddressAnalyze(): reset timeout timer"));
        }
        this.timer.reset(5);
        this.destinationAddress = evt.destAddress;
        JccConnectionEventImpl event = new JccConnectionEventImpl(116, this, 100);
        this.queueEvent((JccEvent)event);
    }

    public void onCallDelivery() {
        this.logger.info((Object)(this + "CALL_DELIVERY, " + OriginatingConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onCallDelivery(): reset timeout timer"));
        }
        this.timer.reset(65);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onCallDelivery(): sending signaling message to MSC"));
        }
        CalledPartyNumber routeNumber = this.destinationAddress.getRouteNumber();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "connecting to " + routeNumber));
        }
        JccCallingPartyNumber cli = (JccCallingPartyNumber)this.getAddress();
        cli.setCLI("777");
        Connect connect = new Connect(routeNumber);
        RequestBCSMState bcsm = new RequestBCSMState();
        bcsm.add(new BCSMEvent(7));
        bcsm.add(new BCSMEvent(6));
        bcsm.add(new BCSMEvent(5));
        bcsm.add(new BCSMEvent(10));
        ApplyCharging applyCharging = new ApplyCharging(128, 1);
        RequestedInformationTypeList list = new RequestedInformationTypeList();
        list.add(1);
        list.add(2);
        list.add(30);
        LegID legID = new LegID(128, 2);
        CallInformationRequest cir = new CallInformationRequest(list, legID);
        Continue cont = new Continue();
        Components components = new Components();
        components.add(new Invoke(1, applyCharging));
        components.add(new Invoke(2, bcsm));
        components.add(new Invoke(3, cir));
        components.add(new Invoke(4, connect));
        TCContinue message = new TCContinue(this.connectionID.getId());
        message.setDialogue(new DialoguePortion());
        message.setComponents(components);
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
        }
        catch (IOException e) {
            this.logger.error((Object)"I/O Error", (Throwable)e);
            JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this, 116);
            this.queueEvent((JccEvent)evt);
        }
    }

    public void onAlerting() {
    }

    public void onConnected() {
        this.logger.info((Object)(this + "CONNECTED, " + OriginatingConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onConnected(): reset timeout timer"));
        }
        this.timer.reset(1805);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onConnected(): sending signaling message to MSC"));
        }
        RequestBCSMState bcsm = new RequestBCSMState();
        bcsm.add(new BCSMEvent(9, new LegID(128, 1)));
        bcsm.add(new BCSMEvent(9, new LegID(128, 2)));
        Continue cont = new Continue();
        Components components = new Components();
        components.add(new Invoke(1, bcsm));
        components.add(new Invoke(2, cont));
        TCContinue message = new TCContinue(this.connectionID.getId());
        message.setComponents(components);
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
        }
        catch (IOException e) {
            this.logger.error((Object)"I/O Error", (Throwable)e);
            JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this, 116);
            this.queueEvent((JccEvent)evt);
        }
    }
}

