/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.gt;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.gt.LinePattern;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyBcdNumber;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;

public class TranslationTable {
    private String fileName;
    private ArrayList rules;
    private Logger logger = Logger.getLogger(TranslationTable.class);

    public TranslationTable(String fileName) {
        this.fileName = fileName;
    }

    private void parse() throws FileNotFoundException, IOException {
        this.rules = new ArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.fileName)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.toLowerCase();
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String[] tokens = line.split(":");
            if (tokens.length != 3) {
                this.logger.warn((Object)("Syntax error at line: " + line));
                continue;
            }
            int ind1 = this.Str2Indicator(tokens[0]);
            if (ind1 == -1) {
                this.logger.warn((Object)("Unknown prefix: " + tokens[0]));
                continue;
            }
            int ind2 = this.Str2Indicator(tokens[2]);
            if (ind2 == -1) {
                this.logger.warn((Object)("Unknown suffix: " + tokens[2]));
                continue;
            }
            LinePattern linePattern = new LinePattern(ind1, ind2, tokens[1]);
            if (linePattern == null) continue;
            this.rules.add(linePattern);
        }
    }

    private int Str2Indicator(String str) {
        if (str.equals("spare")) {
            return 0;
        }
        if (str.equals("unknown")) {
            return 2;
        }
        if (str.equals("subscriber")) {
            return 1;
        }
        if (str.equals("national")) {
            return 3;
        }
        if (str.equals("international")) {
            return 4;
        }
        return -1;
    }

    public CalledPartyNumber translate(CalledPartyNumber origin) throws FileNotFoundException, IOException {
        this.parse();
        for (LinePattern rule : this.rules) {
            if (origin.getNai() != rule.getIncomingType() || !rule.getPattern().matches(origin.getAddress())) continue;
            return new CalledPartyNumber(rule.getOutgoingType(), origin.getInni(), origin.getNpi(), rule.getPattern().getResult(origin.getAddress()));
        }
        return origin;
    }

    public CalledPartyNumber translate(CalledPartyBcdNumber origin) throws FileNotFoundException, IOException {
        this.parse();
        for (LinePattern rule : this.rules) {
            if (origin.getNi() != rule.getIncomingType() || !rule.getPattern().matches(origin.getAddress())) continue;
            return new CalledPartyNumber(rule.getOutgoingType(), 0, origin.getNp(), rule.getPattern().getResult(origin.getAddress()));
        }
        return new CalledPartyNumber(origin.getNi(), 0, origin.getNp(), origin.getAddress());
    }
}

