/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.Operation;
import org.mobicents.jcc.inap.protocol.parms.LegID;
import org.mobicents.jcc.inap.protocol.parms.RequestedInformationList;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class CallInformationReport
extends Operation {
    private RequestedInformationList list;
    private LegID legID;

    public CallInformationReport() {
    }

    public CallInformationReport(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        while (in.available() > 0) {
            int param = in.read() & 0xFF;
            int length = Util.readLen(in);
            byte[] buff = new byte[length];
            in.read(buff);
            switch (param) {
                case 160: {
                    this.list = new RequestedInformationList(buff);
                    break;
                }
                case 163: {
                    this.legID = new LegID(buff);
                }
            }
        }
    }

    public RequestedInformationList getReqInfo() {
        return this.list;
    }

    public LegID getLegID() {
        return this.legID;
    }

    public byte[] toByteArray() {
        return null;
    }

    public String toString() {
        return "CallInformationReport[" + this.list + ", " + this.legID + "]";
    }
}

