/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.mobicents.jcc.inap.protocol.parms.LegID;

public class BCSMEvent
implements Serializable {
    public static final int COLLECTED_INFO = 2;
    public static final int ROUTE_SELECT_FAILURE = 4;
    public static final int O_CALLED_PARTY_BUSY = 5;
    public static final int O_NO_ANSWER = 6;
    public static final int O_ANSWER = 7;
    public static final int O_DISCONNECT = 9;
    public static final int O_ABANDON = 10;
    public static final int TERM_ATTEMPT_AUTHORIZED = 12;
    public static final int T_BUSY = 13;
    public static final int T_NO_ANSWER = 14;
    public static final int T_ANSWER = 15;
    public static final int T_DISCONNECT = 17;
    public static final int T_ABANDON = 18;
    private int code;
    private LegID legID;

    public BCSMEvent(int code) {
        this.code = code;
    }

    public BCSMEvent(int code, LegID legID) {
        this.code = code;
        this.legID = legID;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int len = this.legID == null ? 6 : 11;
        bout.write(48);
        bout.write(len);
        bout.write(128);
        bout.write(1);
        bout.write(this.code);
        bout.write(129);
        bout.write(1);
        bout.write(1);
        if (this.legID != null) {
            bout.write(162);
            bout.write(3);
            try {
                bout.write(this.legID.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bout.toByteArray();
    }

    public String toString() {
        String s = null;
        switch (this.code) {
            case 2: {
                s = "cllected_info";
                break;
            }
            case 4: {
                s = "route_select_failure";
                break;
            }
            case 5: {
                s = "o_called_party_busy";
                break;
            }
            case 6: {
                s = "o_No_Answer";
                break;
            }
            case 7: {
                s = "o_Answer";
                break;
            }
            case 9: {
                s = "o_Disconnect";
                break;
            }
            case 10: {
                s = "o_Abandon";
                break;
            }
            case 12: {
                s = "t_Term_Authorized";
                break;
            }
            case 13: {
                s = "t_Busy";
                break;
            }
            case 14: {
                s = "t_No_Answer";
                break;
            }
            case 15: {
                s = "t_Answer";
                break;
            }
            case 17: {
                s = "t_Disconnect";
                break;
            }
            case 18: {
                s = "t_Abandon";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return s + "[monitor_mode=notify]";
    }
}

