/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class CallingPartyNumber
implements Serializable {
    private int nai;
    private int nii;
    private int npi;
    private int apri;
    private int si;
    private String address;

    public CallingPartyNumber(int nai, int nii, int npi, int apri, int si, String address) {
        this.nai = nai;
        this.nii = nii;
        this.npi = npi;
        this.apri = apri;
        this.si = si;
        this.address = address;
    }

    public CallingPartyNumber(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        int length = bin.length;
        int b = in.read() & 0xFF;
        int oddFlag = (b & 0x80) >> 7;
        this.nai = b & 0x7F;
        b = in.read() & 0xFF;
        this.nii = (b & 0x80) >> 7;
        this.npi = (b & 0x70) >> 4;
        this.apri = (b & 0xC) >> 2;
        this.si = b & 3;
        length -= 2;
        this.address = "";
        while (length - 1 > 0) {
            b = in.read() & 0xFF;
            int d1 = b & 0xF;
            int d2 = (b & 0xF0) >> 4;
            this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
            --length;
        }
        b = in.read() & 0xFF;
        this.address = this.address + Integer.toHexString(b & 0xF);
        if (oddFlag != 1) {
            this.address = this.address + Integer.toHexString((b & 0xF0) >> 4);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getApri() {
        return this.apri;
    }

    public int getNai() {
        return this.nai;
    }

    public int getNii() {
        return this.nii;
    }

    public int getNpi() {
        return this.npi;
    }

    public int getSi() {
        return this.si;
    }

    public String toString() {
        return this.address;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean isOdd = this.address.length() % 2 != 0;
        int b = this.nai;
        if (isOdd) {
            b |= 0x80;
        }
        out.write(b);
        int c = this.npi << 4;
        c |= this.nii << 7;
        c |= this.apri << 2;
        out.write(c |= this.si);
        int count = !isOdd ? this.address.length() : this.address.length() - 1;
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.address.substring(i, i + 1);
            String ds2 = this.address.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (isOdd) {
            String ds1 = this.address.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
        return out.toByteArray();
    }
}

