/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class LegID
implements Serializable {
    public static final int RECEIVING_SIDE_ID = 129;
    public static final int SENDING_SIDE_ID = 128;
    public static final int FIRST_LEG = 1;
    public static final int SECOND_LEG = 2;
    private int legID;
    private int sideID;

    public LegID(int sideID, int legID) {
        this.sideID = sideID;
        this.legID = legID;
    }

    public LegID(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        this.sideID = in.read() & 0xFF;
        in.read();
        this.legID = in.read() & 0xFF;
    }

    public int getSideID() {
        return this.sideID;
    }

    public int getLegID() {
        return this.legID;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(this.sideID);
        bout.write(1);
        bout.write(this.legID);
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("LegID[");
        if (this.sideID == 128) {
            s.append("Sending Side ID:");
        } else {
            s.append("Receiving Side ID:");
        }
        if (this.legID == 1) {
            s.append("First leg");
        } else {
            s.append("Second Leg");
        }
        s.append("]");
        return s.toString();
    }
}

