/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.mobicents.jcc.inap.protocol.parms.CallConnectedElapsedTime;
import org.mobicents.jcc.inap.protocol.parms.Cause;
import org.mobicents.jcc.inap.protocol.parms.DateTime;
import org.mobicents.jcc.inap.protocol.parms.RequestedInformationValue;

public class RequestedInformation
implements Serializable {
    private int type;
    private RequestedInformationValue value;

    public RequestedInformation(int type, RequestedInformationValue value) {
        this.type = type;
        this.value = value;
    }

    public RequestedInformation(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        in.read();
        in.read();
        this.type = in.read();
        in.read();
        int len = in.read();
        byte[] buff = new byte[len];
        in.read(buff);
        switch (this.type) {
            case 0: {
                break;
            }
            case 2: {
                this.value = new CallConnectedElapsedTime(buff);
                break;
            }
            case 1: {
                this.value = new DateTime(buff);
                break;
            }
            case 30: {
                this.value = new Cause(buff);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public RequestedInformationValue getValue() {
        return this.value;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(128);
        bout.write(1);
        bout.write(this.type);
        try {
            bout.write(this.value.toByteArray());
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] buff = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        bout.write(48);
        bout.write(buff.length);
        try {
            bout.write(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String toString() {
        String s = "";
        switch (this.type) {
            case 0: {
                break;
            }
            case 2: {
                s = "duration";
                break;
            }
            case 1: {
                s = "call time";
                break;
            }
            case 30: {
                s = "release cause";
            }
        }
        return s + ":" + this.value;
    }
}

