/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.CallInformationReport;
import org.mobicents.jcc.inap.protocol.EventReportBCSM;
import org.mobicents.jcc.inap.protocol.InitialDP;
import org.mobicents.jcc.inap.protocol.Operation;
import org.mobicents.jcc.inap.protocol.UnknownOperation;
import org.mobicents.jcc.inap.protocol.tcap.Component;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class Invoke
extends Component {
    private int invokeID;
    private Operation operation;

    public Invoke(int invokeID, Operation operation) {
        this.invokeID = invokeID;
        this.operation = operation;
    }

    public Invoke(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        int tag = in.read();
        int len = Util.readLen(in);
        this.invokeID = in.read();
        tag = Util.readTag(in);
        len = Util.readLen(in);
        int code = in.read() & 0xFF;
        tag = in.read();
        len = Util.readLen(in);
        byte[] buff = new byte[len];
        in.read(buff);
        switch (code) {
            case 0: {
                this.operation = new InitialDP(buff);
                break;
            }
            case 44: {
                this.operation = new CallInformationReport(buff);
                break;
            }
            case 24: {
                this.operation = new EventReportBCSM(buff);
                break;
            }
            default: {
                this.operation = new UnknownOperation(code, buff);
            }
        }
    }

    public int getInvokeID() {
        return this.invokeID;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(2);
        bout.write(1);
        bout.write(this.invokeID);
        try {
            bout.write(this.operation.toByteArray());
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] buff = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        bout.write(161);
        bout.write(buff.length);
        try {
            bout.write(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String toString() {
        return "[InvokeID=" + this.invokeID + ", " + this.operation + "]";
    }
}

