/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.DialoguePortion;
import org.mobicents.jcc.inap.protocol.tcap.TCMessage;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class TCBegin
extends TCMessage {
    public TCBegin(long txID) {
        super(txID);
        this.type = 98;
    }

    public TCBegin(byte[] bin) throws IOException {
        this.type = 98;
        ByteArrayInputStream data = new ByteArrayInputStream(bin);
        int tag = data.read();
        int length = data.read();
        if (tag != 72) {
            throw new IOException("Originated TID should be present");
        }
        for (int i = 0; i < length; ++i) {
            this.txID = this.txID << 8 | (long)data.read();
        }
        tag = data.read() & 0xFF;
        length = Util.readLen(data);
        if (tag != 107) {
            throw new IOException("Dialogue portion expected");
        }
        byte[] buff = new byte[length];
        data.read(buff);
        this.dialogue = new DialoguePortion(buff);
        tag = data.read() & 0xFF;
        length = Util.readLen(data);
        if (tag != 108) {
            throw new IOException("Component portion expected");
        }
        if (length == 0) {
            length = 126;
        }
        buff = new byte[length];
        data.read(buff);
        this.components = new Components(buff);
    }

    public String toString() {
        return "BEGIN (tx=" + this.getTxID() + "," + this.components + ")";
    }
}

