/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Util {
    public static synchronized int readLen(InputStream in) throws IOException {
        int b = in.read() & 0xFF;
        if ((b & 0x80) != 128) {
            return b;
        }
        int count = b & 0x7F;
        int length = 0;
        for (int i = 0; i < count; ++i) {
            length <<= 8;
            length |= in.read() & 0xFF;
        }
        return length;
    }

    public static synchronized int readTag(InputStream in) throws IOException {
        int b = in.read() & 0xFF;
        int tagClass = b & 0xC0;
        boolean isPrimitive = (b & 0x20) != 32;
        int code = b & 0x1F;
        if (code == 31) {
            code = 0;
            while (((b = in.read() & 0xFF) & 0x80) == 128) {
                code <<= 7;
                code |= b & 0x7F;
            }
            code <<= 7;
            code |= b & 0x7F;
        }
        return code;
    }

    protected static synchronized byte[] intToByteArray(int mask, int shift, int num) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((mask & num) != 0) {
            int b = mask & num;
            out.write((byte)b);
            mask <<= shift;
        }
        byte[] buffer = out.toByteArray();
        int len = buffer.length;
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[len - (1 + i)] = buffer[i];
        }
        return data;
    }

    public static synchronized void encodeLength(int length, OutputStream out) throws IOException {
        if (length < 128) {
            out.write((byte)length);
        } else {
            byte[] buffer = Util.intToByteArray(255, 8, length);
            int len = buffer.length;
            int b = len | 0x80;
            out.write((byte)b);
            for (int i = 0; i < len; ++i) {
                out.write(buffer[i]);
            }
        }
    }

    public static synchronized void encodeTransactioID(int tag, long tid, OutputStream out) throws IOException {
        out.write(tag);
        out.write(4);
        out.write((byte)((tid & 0xFFFFFFFFFF000000L) >> 24));
        out.write((byte)((tid & 0xFF0000L) >> 16));
        out.write((byte)((tid & 0xFF00L) >> 8));
        out.write((byte)(tid & 0xFFL));
    }
}

