/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.ss7.sccp.GlobalTitle;

public class GT0100
extends GlobalTitle {
    private int translationType;
    private int numberingPlan;
    private int encodingScheme;
    private int natureOfAddress;
    private String digits = "";

    public GT0100() {
    }

    public GT0100(int translationType, int numberingPlan, int encodingScheme, int natureOfAddress, String digits) {
        this.translationType = translationType;
        this.numberingPlan = numberingPlan;
        this.encodingScheme = encodingScheme;
        this.natureOfAddress = natureOfAddress;
        this.digits = digits;
    }

    public void decode(InputStream in) throws IOException {
        int b;
        int b1 = in.read() & 0xFF;
        int b2 = in.read() & 0xFF;
        int b3 = in.read() & 0xFF;
        this.translationType = b1;
        this.numberingPlan = (b2 & 0xF0) >> 4;
        this.encodingScheme = b2 & 0xF;
        this.natureOfAddress = b3 & 0x3F;
        while (in.available() > 1) {
            b = in.read() & 0xFF;
            this.digits = this.digits + Integer.toHexString(b & 0xF) + Integer.toHexString((b & 0xF0) >> 4);
        }
        b = in.read() & 0xFF;
        this.digits = this.digits + Integer.toHexString(b & 0xF);
        if (this.encodingScheme != 1) {
            this.digits = this.digits + Integer.toHexString((b & 0xF0) >> 4);
        }
    }

    public void encode(OutputStream out) throws IOException {
        out.write((byte)this.translationType);
        byte b = (byte)(this.numberingPlan << 4 | this.encodingScheme);
        out.write(b);
        b = (byte)(this.natureOfAddress & 0x3F);
        out.write(b);
        int count = this.encodingScheme != 1 ? this.digits.length() : this.digits.length() - 1;
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.digits.substring(i, i + 1);
            String ds2 = this.digits.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (this.encodingScheme == 1) {
            String ds1 = this.digits.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("Global Title includes translation type, numbering plan, encoding scheme, nature of address indicator\n");
        msg.append(this.digits);
        return msg.toString();
    }
}

