/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.ss7.sccp.GT0100;
import org.mobicents.ss7.sccp.GlobalTitle;

public class SccpAddress {
    protected int pointCodeIndicator;
    protected int ssnIndicator;
    protected int globalTitleIndicator;
    protected int routingIndicator;
    protected int signalingPointCode;
    protected int ssn;
    protected GlobalTitle globalTitle;

    public SccpAddress() {
    }

    public SccpAddress(int pointCodeIndicator, int ssnIndicator, int gtIndicator, int routingIndicator, int signalingPointCode, int ssn, GlobalTitle globalTitle) {
        this.pointCodeIndicator = pointCodeIndicator;
        this.ssnIndicator = ssnIndicator;
        this.globalTitleIndicator = gtIndicator;
        this.routingIndicator = routingIndicator;
        this.signalingPointCode = signalingPointCode;
        this.ssn = ssn;
        this.globalTitle = globalTitle;
    }

    public void decode(byte[] buffer) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        int i = in.readUnsignedByte();
        this.pointCodeIndicator = i & 1;
        this.ssnIndicator = (i & 2) >> 1;
        this.globalTitleIndicator = (i & 0x3C) >> 2;
        this.routingIndicator = (i & 0x40) >> 6;
        if (this.pointCodeIndicator == 1) {
            int b1 = in.readUnsignedByte();
            int b2 = in.readUnsignedByte();
            this.signalingPointCode = (b2 & 0x3F) << 8 | b1;
        }
        if (this.ssnIndicator == 1) {
            this.ssn = in.readUnsignedByte();
        }
        switch (this.globalTitleIndicator) {
            case 4: {
                this.globalTitle = new GT0100();
            }
        }
        this.globalTitle.decode(in);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte b = (byte)(this.pointCodeIndicator | this.ssnIndicator << 1 | this.globalTitleIndicator << 2 | this.routingIndicator << 6);
        out.write(b);
        if (this.pointCodeIndicator == 1) {
            byte b1 = (byte)this.signalingPointCode;
            byte b2 = (byte)(this.signalingPointCode >> 8 & 0x3F);
            out.write(b1);
            out.write(b2);
        }
        if (this.ssnIndicator == 1) {
            out.write((byte)this.ssn);
        }
        this.globalTitle.encode(out);
        return out.toByteArray();
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        if (this.pointCodeIndicator == 1) {
            msg.append("Address contains a signaling point code\n");
        } else {
            msg.append("Address contains no signaling point code\n");
        }
        if (this.ssnIndicator == 1) {
            msg.append("Address contains a subsystem number\n");
        } else {
            msg.append("Address contains no subsystem number\n");
        }
        msg.append(this.globalTitle.toString());
        return msg.toString();
    }
}

