/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.ss7.sccp.Pdu;
import org.mobicents.ss7.sccp.ProtocolClass;
import org.mobicents.ss7.sccp.SccpAddress;

public class UnitData
extends Pdu {
    private SccpAddress calledParty;
    private SccpAddress callingParty;
    private byte[] data;
    private ProtocolClass pClass;

    public UnitData() {
    }

    public UnitData(ProtocolClass pClass, SccpAddress calledParty, SccpAddress callingParty, byte[] data) {
        this.pClass = pClass;
        this.calledParty = calledParty;
        this.callingParty = callingParty;
        this.data = data;
    }

    public SccpAddress getCalledParty() {
        return this.calledParty;
    }

    public SccpAddress getCallingParty() {
        return this.callingParty;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream out) throws IOException {
        out.write(9);
        this.pClass.encode(out);
        byte[] cdp = this.calledParty.encode();
        byte[] cnp = this.callingParty.encode();
        int len = 3;
        out.write(len);
        len = cdp.length + 3;
        out.write(len);
        out.write(len += cnp.length);
        out.write((byte)cdp.length);
        out.write(cdp);
        out.write((byte)cnp.length);
        out.write(cnp);
        out.write((byte)this.data.length);
        out.write(this.data);
    }

    public void decode(InputStream in) throws IOException {
        this.pClass = new ProtocolClass();
        this.pClass.decode(in);
        int cpaPointer = in.read() & 0xFF;
        in.mark(in.available());
        in.skip(cpaPointer - 1);
        int len = in.read() & 0xFF;
        byte[] buffer = new byte[len];
        in.read(buffer);
        this.calledParty = new SccpAddress();
        this.calledParty.decode(buffer);
        in.reset();
        cpaPointer = in.read() & 0xFF;
        in.mark(in.available());
        in.skip(cpaPointer - 1);
        len = in.read() & 0xFF;
        buffer = new byte[len];
        in.read(buffer);
        this.callingParty = new SccpAddress();
        this.callingParty.decode(buffer);
        in.reset();
        cpaPointer = in.read() & 0xFF;
        in.skip(cpaPointer - 1);
        len = in.read() & 0xFF;
        this.data = new byte[len];
        in.read(this.data);
    }
}

