/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.jcc.local;

import javax.csapi.cc.jcc.EventFilter;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidPartyException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccCallListener;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccProvider;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.mobicents.slee.resource.jcc.local.JccConnectionLocal;
import org.mobicents.slee.resource.jcc.local.JccProviderLocal;
import org.mobicents.slee.resource.jcc.ra.JccResourceAdaptor;

public class JccCallLocal
implements JccCall {
    private JccCall call;
    private JccProviderLocal provider;

    public JccCallLocal(JccCall call, JccProviderLocal provider) {
        this.call = call;
        this.provider = provider;
    }

    public void addCallListener(JccCallListener listener) throws ResourceUnavailableException, MethodNotSupportedException {
        if (!(listener instanceof JccResourceAdaptor)) {
            throw new SecurityException("SBB may not add event listener");
        }
        this.call.addCallListener(listener);
    }

    public void addConnectionListener(JccConnectionListener listener, EventFilter eventFilter) throws ResourceUnavailableException, MethodNotSupportedException {
        if (!(listener instanceof JccResourceAdaptor)) {
            throw new SecurityException("SBB may not add event listener");
        }
        this.call.addCallListener((JccCallListener)listener);
    }

    public JccConnection[] connect(JccAddress origAddress, String dialedDigits) throws ResourceUnavailableException, PrivilegeViolationException, InvalidPartyException, InvalidStateException, MethodNotSupportedException {
        JccConnection[] connections = this.call.connect(origAddress, dialedDigits);
        JccConnection[] localConnections = new JccConnectionLocal[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            localConnections[i] = new JccConnectionLocal(connections[i], this.provider, this);
        }
        return localConnections;
    }

    public JccConnection createConnection(String targetAddress, String originatingAddress, String originalCalledAddress, String redirectingAddress) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidArgumentException, InvalidPartyException {
        return new JccConnectionLocal(this.call.createConnection(targetAddress, originatingAddress, originalCalledAddress, redirectingAddress), this.provider, this);
    }

    public JccConnection[] getConnections() {
        JccConnection[] connections = this.call.getConnections();
        JccConnection[] localConnections = new JccConnectionLocal[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            localConnections[i] = new JccConnectionLocal(connections[i], this.provider, this);
        }
        return localConnections;
    }

    public JccProvider getProvider() {
        return this.provider;
    }

    public int getState() {
        return this.call.getState();
    }

    public void release(int causeCode) throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException, InvalidArgumentException {
        this.call.release(causeCode);
    }

    public void removeCallListener(JccCallListener listener) {
        if (!(listener instanceof JccResourceAdaptor)) {
            throw new SecurityException("SBB may not remove event listener");
        }
        this.call.removeCallListener(listener);
    }

    public void removeConnectionListener(JccConnectionListener listener) {
        if (!(listener instanceof JccResourceAdaptor)) {
            throw new SecurityException("SBB may not remove event listener");
        }
        this.call.removeConnectionListener(listener);
    }

    public JccConnection routeCall(String targetAddress, String originatingAddress, String originalDestinationAddress, String redirectingAddress) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidPartyException, InvalidArgumentException {
        return new JccConnectionLocal(this.call.routeCall(targetAddress, originatingAddress, originalDestinationAddress, redirectingAddress), this.provider, this);
    }

    public void superviseCall(JccCallListener listener, double time, int treatment) throws MethodNotSupportedException {
        this.call.superviseCall(listener, time, treatment);
    }

    public boolean equals(Object other) {
        return other instanceof JccCallLocal && ((JccCallLocal)other).call == this.call;
    }

    public String toString() {
        return this.call.toString();
    }
}

