/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.jcc.ra;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccCallEvent;
import javax.csapi.cc.jcc.JccCallListener;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionEvent;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccEvent;
import javax.csapi.cc.jcc.JccPeer;
import javax.csapi.cc.jcc.JccPeerFactory;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.EventTypeID;
import javax.slee.SLEEException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireEventException;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.IllegalEventException;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import javax.slee.resource.UnrecognizedActivityHandleException;
import org.mobicents.slee.resource.jcc.local.JccCallEventLocal;
import org.mobicents.slee.resource.jcc.local.JccCallLocal;
import org.mobicents.slee.resource.jcc.local.JccConnectionEventLocal;
import org.mobicents.slee.resource.jcc.local.JccConnectionLocal;
import org.mobicents.slee.resource.jcc.local.JccProviderLocal;
import org.mobicents.slee.resource.jcc.ra.JccCallActivityHandle;
import org.mobicents.slee.resource.jcc.ra.JccConnectionActivityHandle;
import org.mobicents.slee.resource.jcc.ratype.JccActivityContextInterfaceFactory;

public class JccResourceAdaptor
implements ResourceAdaptor,
Serializable,
JccConnectionListener {
    private static final String _CONFIG_OPT_NAME_JCCPEER = "jccPeer";
    private static final String _CONFIG_OPT_NAME_CONF = "configName";
    private JccProviderLocal provider;
    private Address address = new Address(AddressPlan.IP, "127.0.0.1");
    private Tracer logger = null;
    private ConcurrentReaderHashMap activities = new ConcurrentReaderHashMap();
    private ConcurrentReaderHashMap handlers = new ConcurrentReaderHashMap();
    private String peerName = null;
    private String configName;
    private JccActivityContextInterfaceFactory activityContextInterfaceFactory;
    private boolean stopped = false;
    private Thread monitor;
    private String xmlConvofiguration = "";
    private ResourceAdaptorContext raContext;
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookupFacility;
    public static final int DEFAULT_EVENT_FLAGS = 64;
    private static final int ACTIVITY_FLAGS = 2;

    public String getJccPeer() {
        return this.peerName;
    }

    public void setJccPeer(String jccPeer) {
        this.peerName = jccPeer;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.provider;
    }

    public void raConfigure(ConfigProperties cps) {
        block5: {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Configuring JCCRA: " + this.raContext.getEntityName());
                }
                Properties properties = new Properties();
                properties.load(this.getClass().getResourceAsStream("/" + this.configName));
                this.logger.info("Loaded properties: " + properties);
                this.xmlConvofiguration = "<jcc-inap>";
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    this.xmlConvofiguration = this.xmlConvofiguration + ";" + key + "=" + properties.getProperty(key);
                }
            }
            catch (UnsatisfiedLinkError ex) {
                this.logger.warning("JCC Resource adaptor is not attached to baord driver", (Throwable)ex);
            }
            catch (Exception e) {
                if (!this.logger.isSevereEnabled()) break block5;
                this.logger.severe("Can not start Jcc Provider: ", (Throwable)e);
            }
        }
    }

    public void raVerifyConfiguration(ConfigProperties cps) throws InvalidConfigurationException {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Verifyin configuring JCCRA: " + this.raContext.getEntityName());
            }
            this.configName = (String)cps.getProperty(_CONFIG_OPT_NAME_CONF).getValue();
            this.peerName = (String)cps.getProperty(_CONFIG_OPT_NAME_JCCPEER).getValue();
            if (this.configName == null) {
                throw new InvalidConfigurationException("No name set for configuration file.");
            }
            if (this.peerName == null) {
                throw new InvalidConfigurationException("No name set jcc peer.");
            }
            if (null == this.getClass().getResource("/" + this.configName)) {
                throw new InvalidConfigurationException("Configuration file: " + this.configName + ", can not be located.");
            }
        }
        catch (InvalidConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Failed to test configuration options!", (Throwable)e);
        }
        this.logger.info("JCC Provider started successfuly");
        this.logger.info("Running monitoring thread");
    }

    public void raActive() {
        try {
            JccPeer peer = JccPeerFactory.getJccPeer((String)this.peerName);
            this.provider = new JccProviderLocal(peer.getProvider(this.xmlConvofiguration));
            this.provider.addConnectionListener(this, null);
            this.provider.addCallListener((JccCallListener)this);
            this.logger.info("JCC Provider started successfuly");
            this.monitor = new Thread(new ActivityMonitor());
            this.monitor.start();
            this.logger.info("Running monitoring thread");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (ResourceUnavailableException e) {
            e.printStackTrace();
        }
        catch (MethodNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void raStopping() {
        try {
            this.provider.shutdown();
            this.provider = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Object o : this.handlers.values()) {
            ActivityHandle ah = (ActivityHandle)o;
            try {
                this.sleeEndpoint.endActivity(ah);
            }
            catch (UnrecognizedActivityException uae) {
                if (this.logger.isSevereEnabled()) {
                    this.logger.severe("Caught an UnrecognizedActivityException: ");
                }
                uae.printStackTrace();
            }
        }
    }

    public void raInactive() {
        this.stopped = true;
        this.monitor.interrupt();
        this.monitor = null;
    }

    public void raUnconfigure() {
        this.xmlConvofiguration = null;
        this.configName = null;
        this.peerName = null;
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.raContext = raContext;
        this.logger = raContext.getTracer("JccResourceAdaptor");
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventLookupFacility = raContext.getEventLookupFacility();
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventLookupFacility = null;
    }

    public void activityEnded(ActivityHandle handle) {
        String ID = ((JccConnectionActivityHandle)handle).getID();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Activity ended id: " + ID + ", handle: " + handle);
        }
        Object activity = this.activities.remove((Object)ID);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Activity ended activity: " + activity);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Removed activity: " + activity + " under key: " + ID);
        }
        JccConnectionActivityHandle h = (JccConnectionActivityHandle)this.handlers.remove((Object)activity.toString());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Activity ended removed handler: " + h);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Removed handle: " + h.getID() + " under key: " + activity.toString());
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle handle) {
        String ID = ((JccConnectionActivityHandle)handle).getID();
        return this.activities.get((Object)ID);
    }

    public ActivityHandle getActivityHandle(Object obj) {
        return (ActivityHandle)this.handlers.get((Object)obj.toString());
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void callActive(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_ACTIVE event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_ACTIVE", handle, (JccEvent)evt);
    }

    public void callCreated(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_CREATED event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        JccCallActivityHandle handle = new JccCallActivityHandle(call);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Starting activity: " + call + ", handle: " + handle);
            }
            this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)call, 2);
        }
        catch (ActivityAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (SLEEException e) {
            e.printStackTrace();
        }
        catch (StartActivityException e) {
            e.printStackTrace();
        }
        this.activities.put((Object)call, (Object)handle);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CREATED", handle, (JccEvent)evt);
    }

    public void callEventTransmissionEnded(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_EVENT_TRANSMISSION_ENDED event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_EVENT_TRANSMISSION_ENDED", handle, (JccEvent)evt);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("callEventTransmissionEnded : ending activity " + handle);
            }
            this.sleeEndpoint.endActivity(handle);
        }
        catch (UnrecognizedActivityException uae) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an UnrecognizedActivityException: ");
            }
            uae.printStackTrace();
        }
    }

    public void callInvalid(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_INVALID event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_INVALID", handle, (JccEvent)evt);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("callInvalid : ending activity " + handle);
            }
            this.sleeEndpoint.endActivity(handle);
        }
        catch (UnrecognizedActivityException uae) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an UnrecognizedActivityException: ");
            }
            uae.printStackTrace();
        }
    }

    public void callSuperviseEnd(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_SUPERVISE_END event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CSUPERVISE_END", handle, (JccEvent)evt);
    }

    public void callSuperviseStart(JccCallEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccCallEvent.CALL_SUPERVISE_START event");
        }
        JccCallEventLocal evt = this.wrapJccCallEvent(event);
        JccCall call = evt.getCall();
        ActivityHandle handle = this.getActivityHandle(call);
        this.fireEvent("javax.csapi.cc.jcc.JccCallEvent.CALL_CSUPERVISE_START", handle, (JccEvent)evt);
    }

    public void connectionAddressAnalyze(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_ADDRESS_ANALYZE event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ADDRESS_ANALYZE", handle, (JccEvent)evt);
    }

    public void connectionAddressCollect(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_ADDRESS_COLLECT event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ADDRESS_COLLECT", handle, (JccEvent)evt);
    }

    public void connectionAlerting(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_ALERTING event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_ALERTING", handle, (JccEvent)evt);
    }

    public void connectionAuthorizeCallAttempt(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_AUTHORIZE_CALL_ATTEMPT event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_AUTHORIZE_CALL_ATTEMPT", handle, (JccEvent)evt);
    }

    public void connectionCallDelivery(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_CALL_DELIVERY event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CALL_DELIVERY", handle, (JccEvent)evt);
    }

    public void connectionConnected(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_CONNECTED event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CONNECTED", handle, (JccEvent)evt);
    }

    public void connectionCreated(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_CREATED event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        JccConnectionActivityHandle handle = new JccConnectionActivityHandle(connection);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Starting activity: " + connection + ", handle: " + handle);
            }
            this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)connection, 2);
        }
        catch (ActivityAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (SLEEException e) {
            e.printStackTrace();
        }
        catch (StartActivityException e) {
            e.printStackTrace();
        }
        this.handlers.put((Object)connection.toString(), (Object)handle);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onConnectionCreate():put handle: " + handle + " under key: " + connection.toString());
        }
        this.activities.put((Object)handle.getID(), (Object)connection);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onConnectionCreate():put connection " + connection + " under key: " + handle.getID());
        }
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_CREATED", handle, (JccEvent)evt);
    }

    public void connectionDisconnected(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_DISCONNECTED event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection.toString());
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_DISCONNECTED", handle, (JccEvent)evt);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("connectionDisconnected : ending activity " + handle + ", activity: " + connection);
            }
            this.sleeEndpoint.endActivity(handle);
        }
        catch (UnrecognizedActivityException uae) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an UnrecognizedActivityException: ");
            }
            uae.printStackTrace();
        }
    }

    public void connectionFailed(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_FAILED event");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onfailed(): connectionID: " + connection.toString());
        }
        ActivityHandle handle = this.getActivityHandle(connection);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("connectionFailed : ending activity " + handle + ", activity: " + connection);
        }
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_FAILED", handle, (JccEvent)evt);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onfailed(): handle=" + handle);
        }
    }

    public void connectionMidCall(JccConnectionEvent event) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Receive JccConnection.CONNECTION_MID_CALLevent");
        }
        JccConnectionEventLocal evt = this.wrapJccConnectionEvent(event);
        JccConnection connection = evt.getConnection();
        ActivityHandle handle = this.getActivityHandle(connection);
        this.fireEvent("javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_MID_CALL", handle, (JccEvent)evt);
    }

    private JccConnectionEventLocal wrapJccConnectionEvent(JccConnectionEvent event) {
        JccCallLocal call = new JccCallLocal(event.getCall(), this.provider);
        JccConnectionLocal connection = new JccConnectionLocal(event.getConnection(), this.provider, call);
        return new JccConnectionEventLocal(connection, event.getID(), event.getCause(), event.getSource(), call);
    }

    private JccCallEventLocal wrapJccCallEvent(JccCallEvent event) {
        JccCallLocal call = new JccCallLocal(event.getCall(), this.provider);
        return new JccCallEventLocal(event.getID(), event.getCause(), event.getSource(), call);
    }

    private void fireEvent(String eventName, ActivityHandle activityHandle, JccEvent event) {
        FireableEventType eventID = null;
        try {
            EventTypeID eventTypeId = new EventTypeID(eventName, "javax.csapi.cc.jcc", "1.1");
            eventID = this.eventLookupFacility.getFireableEventType(eventTypeId);
        }
        catch (FacilityException fe) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught a FacilityException: ");
            }
            fe.printStackTrace();
            throw new RuntimeException("JccResourceAdaptor.firEvent(): FacilityException caught. ", fe);
        }
        catch (UnrecognizedEventException ue) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an UnrecognizedEventException: ");
            }
            ue.printStackTrace();
            throw new RuntimeException("JccResourceAdaptor.firEvent(): UnrecognizedEventException caught.", ue);
        }
        if (eventID == null) {
            if (this.logger.isWarningEnabled()) {
                this.logger.warning("Unknown event type: " + eventName);
            }
            return;
        }
        try {
            this.sleeEndpoint.fireEvent(activityHandle, eventID, (Object)event, this.address, null);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Fire event: " + eventName);
            }
        }
        catch (IllegalStateException ise) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an IllegalStateException: ");
            }
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an ActivityIsEndingException: ");
            }
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            if (this.logger.isSevereEnabled()) {
                this.logger.severe("Caught an UnrecognizedActivityException: ");
            }
            uaee.printStackTrace();
        }
        catch (UnrecognizedActivityHandleException e) {
            e.printStackTrace();
        }
        catch (IllegalEventException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (SLEEException e) {
            e.printStackTrace();
        }
        catch (FireEventException e) {
            e.printStackTrace();
        }
    }

    private class ActivityMonitor
    implements Runnable {
        private ActivityMonitor() {
        }

        public void run() {
            while (!JccResourceAdaptor.this.stopped) {
                try {
                    Thread.currentThread();
                    Thread.sleep(60000L);
                    JccResourceAdaptor.this.logger.info("activities=" + JccResourceAdaptor.this.activities.size() + ", handlers=" + JccResourceAdaptor.this.handlers.size());
                    JccResourceAdaptor.this.logger.info("activities: " + JccResourceAdaptor.this.activities);
                    JccResourceAdaptor.this.logger.info("handlers: " + JccResourceAdaptor.this.handlers);
                }
                catch (InterruptedException e) {
                    JccResourceAdaptor.this.stopped = true;
                }
            }
        }
    }
}

