/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.ra;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.lab.message.IncorrectRequestFormatException;
import org.mobicents.slee.resource.lab.message.Message;
import org.mobicents.slee.resource.lab.message.MessageEvent;
import org.mobicents.slee.resource.lab.message.MessageFactory;
import org.mobicents.slee.resource.lab.message.MessageFactoryImpl;
import org.mobicents.slee.resource.lab.message.MessageParser;
import org.mobicents.slee.resource.lab.message.MessageParserImpl;
import org.mobicents.slee.resource.lab.ra.MessageActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.lab.ra.MessageActivityHandle;
import org.mobicents.slee.resource.lab.ra.MessageActivityImpl;
import org.mobicents.slee.resource.lab.ra.MessageResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.resource.lab.ratype.MessageActivity;
import org.mobicents.slee.resource.lab.ratype.MessageActivityContextInterfaceFactory;
import org.mobicents.slee.resource.lab.ratype.MessageResourceAdaptorSbbInterface;
import org.mobicents.slee.resource.lab.stack.RAFStack;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;

public class MessageResourceAdaptor
implements RAFStackListener,
ResourceAdaptor,
Serializable {
    private static transient Logger logger = Logger.getLogger(MessageResourceAdaptor.class);
    private int port = 40000;
    private int remoteport = 40001;
    private String remotehost = "127.0.0.1";
    private String stackName = "RAFrameResourceAdaptor";
    private transient Properties properties = null;
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient RAFStack stack = null;
    private transient HashMap activities = null;
    private transient MessageActivityContextInterfaceFactory acif = null;
    private transient MessageFactory messageFactory = null;
    private transient MessageResourceAdaptorSbbInterface raProvider = null;
    private transient MessageParser messageParser;

    public MessageResourceAdaptor(Properties properties) {
        this.properties = properties;
        this.port = Integer.parseInt(properties.getProperty("com.maretzke.raframe.stack.PORT"));
        this.remoteport = Integer.parseInt(properties.getProperty("com.maretzke.raframe.stack.REMOTEPORT"));
        this.remotehost = properties.getProperty("com.maretzke.raframe.stack.REMOTEHOST");
        this.stackName = properties.getProperty("com.maretzke.raframe.stack.STACK_NAME");
        logger.debug((Object)("RAFrameResourceAdaptor(" + properties + ") called."));
    }

    public MessageResourceAdaptor(String stackName, int port, String remotehost, int remoteport) {
        this.port = port;
        this.remotehost = remotehost;
        this.remoteport = remoteport;
        this.stackName = stackName;
        logger.debug((Object)("RAFrameResourceAdaptor(" + stackName + ", " + port + ", " + remotehost + ", " + remoteport + ") called."));
    }

    public MessageResourceAdaptor() {
        logger.debug((Object)"RAFrameResourceAdaptor() called.");
    }

    public void onEvent(String incomingData) {
        int eventID;
        MessageEvent event;
        System.out.println("onEvent of RAFrameResourceAdaptor " + incomingData);
        logger.debug((Object)("Incoming request: " + incomingData));
        try {
            Message message = this.messageParser.parse(incomingData);
            event = this.messageFactory.createMessageEvent((Object)this, message);
        }
        catch (IncorrectRequestFormatException irfe) {
            logger.debug((Object)("Incoming request: " + incomingData + " does not follow the defined message rules (ID COMMAND). Dropping the event."));
            irfe.printStackTrace();
            return;
        }
        MessageActivityHandle handle = new MessageActivityHandle(event.getMessage().getId());
        MessageActivity activity = (MessageActivity)this.activities.get(handle);
        if (activity == null) {
            activity = new MessageActivityImpl(event.getMessage().getId());
            this.activities.put(handle, activity);
        }
        if (!activity.isValid(event.getMessage().getCommandId())) {
            logger.debug((Object)"Not a valid command. Command corrupts rules defined for the protocol.");
            System.out.println("Not a valid command. Command corrupts rules defined for the protocol.");
            return;
        }
        Address address = new Address(AddressPlan.IP, "127.0.0.1");
        try {
            eventID = this.eventLookup.getEventID("org.mobicents.slee.resource.lab.message.incoming." + event.getMessage().getCommand().toUpperCase(), "org.mobicents", "1.0");
        }
        catch (FacilityException fe) {
            logger.error((Object)"Caught a FacilityException: ");
            fe.printStackTrace();
            throw new RuntimeException("RAFrameResourceAdapter.onEvent(): FacilityException caught. ", fe);
        }
        catch (UnrecognizedEventException uee) {
            logger.error((Object)"Caught an UnrecognizedEventException: ");
            uee.printStackTrace();
            throw new RuntimeException("RAFrameResourceAdaptor.onEvent(): UnrecognizedEventException caught.", uee);
        }
        if (eventID == -1) {
            System.out.println("Cant get EventId");
            logger.debug((Object)"RAFrameResourceAdaptor.onEvent(): Event lookup -- could not find event mapping -- check xml/slee-events.xml");
            return;
        }
        try {
            if (event.getMessage().getCommand().toLowerCase().compareTo("end") == 0) {
                logger.debug((Object)("RAFrameResourceAdaptor.onEvent(): RAFrameRA signals ending activity to SLEE. EventID: " + eventID + "; CallID:  " + event.getMessage().getId() + "; Command: " + event.getMessage().getCommand()));
                this.sleeEndpoint.activityEnding((ActivityHandle)new MessageActivityHandle(event.getMessage().getId()));
            } else {
                logger.debug((Object)("RAFrameResourceAdaptor.onEvent(): RAFrameRA fires event into SLEE. EventID: " + eventID + "; CallID:  " + event.getMessage().getId() + "; Command: " + event.getMessage().getCommand()));
                System.out.println("RAFrameResourceAdaptor.onEvent(): RAFrameRA fires event into SLEE. EventID: " + eventID + "; CallID:  " + event.getMessage().getId() + "; Command: " + event.getMessage().getCommand());
                this.sleeEndpoint.fireEvent((ActivityHandle)new MessageActivityHandle(event.getMessage().getId()), (Object)event, eventID, address);
            }
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Caught an IllegalStateException: ");
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            logger.error((Object)"Caught an ActivityIsEndingException: ");
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uaee.printStackTrace();
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.debug((Object)"RAFrameResourceAdaptor.entityCreated() called.");
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.stack = null;
    }

    public void entityRemoved() {
        logger.debug((Object)"RAFrameResourceAdaptor.entityRemoved() called.");
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object obj, int param, Address address, int flags) {
        logger.debug((Object)"RAFrameResourceAdaptor.eventProcessingSuccessful() called.");
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object obj, int param, Address address, int flags, FailureReason failureReason) {
        logger.debug((Object)"RAFrameResourceAdaptor.eventProcessingFailed() called.");
    }

    public void activityEnded(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        logger.debug((Object)"RAFrameResourceAdaptor.activityEnded() called.");
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        logger.debug((Object)"RAFrameResourceAdaptor.activityUnreferenced() called.");
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        logger.debug((Object)"RAFrameResourceAdaptor.queryLifeness() called.");
    }

    public Object getActivity(ActivityHandle activityHandle) {
        logger.debug((Object)"RAFrameResourceAdaptor.getActivity() called.");
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object obj) {
        logger.debug((Object)"RAFrameResourceAdaptor.getActivityHandle(obj) called.");
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        logger.debug((Object)("RAFrameResourceAdaptor.getSBBResourceAdapterInterface(" + str + ") called."));
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        logger.debug((Object)"RAFrameResourceAdaptor.getMarshaler() called.");
        return null;
    }

    public void serviceInstalled(String str, int[] values, String[] str2) {
        logger.debug((Object)"RAFrameResourceAdaptor.serviceInstalled() called.");
    }

    public void serviceUninstalled(String str) {
        logger.debug((Object)"RAFrameResourceAdaptor.serviceUninstalled() called.");
    }

    public void serviceActivated(String str) {
        logger.debug((Object)"RAFrameResourceAdaptor.serviceActivated() called.");
    }

    public void serviceDeactivated(String str) {
        logger.debug((Object)"RAFrameResourceAdaptor.serviceDeactivated() called.");
    }

    public void entityActivated() throws ResourceException {
        logger.debug((Object)"RAFrameResourceAdaptor.entityActivated() called.");
        try {
            logger.debug((Object)("Starting RAFStack at port " + this.port));
            try {
                this.messageFactory = new MessageFactoryImpl();
                this.raProvider = new MessageResourceAdaptorSbbInterfaceImpl(this, this.messageFactory);
                this.messageParser = new MessageParserImpl();
                this.stack = new RAFStack(this.port, this.remotehost, this.remoteport);
                this.stack.addListener(this);
                this.stack.start();
                logger.debug((Object)"RAFStack up and running.");
                System.out.println("RAFStack up and running.");
                this.initializeNamingContext();
            }
            catch (Exception ex) {
                logger.error((Object)"RAFrameResouceAdaptor.start(): Exception caught! ");
                ex.printStackTrace();
                throw new ResourceException(ex.getMessage());
            }
            this.activities = new HashMap();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("RAFrameResourceAdaptor.entityActivated(): Failed to activate RAFrame Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivated() {
        logger.debug((Object)"RAFrameResourceAdaptor.entityDeactivated() called.");
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind naming context");
        }
        logger.debug((Object)"RAFrame Resource Adaptor stopped.");
    }

    public void entityDeactivating() {
        logger.debug((Object)"RAFrameResourceAdaptor.entityDeactivating() called.");
        logger.debug((Object)"Shuting down the stack.");
        this.stack.shutdown();
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new MessageActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                System.out.println("jndiName prefix =" + prefix + "; jndiName = " + name);
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("JNDI name to unregister: " + javaJNDIName));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"JNDI name unregistered.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    public void send(String message) {
        logger.debug((Object)("Sending message to stack: " + message));
        this.stack.send(message);
    }
}

