/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.stack;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;
import org.mobicents.slee.resource.lab.stack.RAFStackThread;

public class RAFStack
extends Thread {
    private static Logger logger = Logger.getLogger(RAFStack.class);
    private ServerSocket server;
    private int port;
    private int remoteport;
    private String remotehost;
    private ArrayList listener;
    private boolean shutdown = false;

    public RAFStack(int port, String remotehost, int remoteport) throws IOException {
        logger.debug((Object)"RAFStack instantiated.");
        this.port = port;
        this.remotehost = remotehost;
        this.remoteport = remoteport;
        this.listener = new ArrayList();
        this.server = new ServerSocket(port);
        this.server.setSoTimeout(1000);
    }

    public void addListener(RAFStackListener listener) {
        this.listener.add(listener);
    }

    public void run() {
        Socket socket = null;
        while (!this.shutdown) {
            try {
                socket = this.server.accept();
                new RAFStackThread(socket, this, this.listener).start();
            }
            catch (SocketTimeoutException ste) {
            }
            catch (SocketException ste) {
            }
            catch (IOException ioe) {
                logger.error((Object)("IOException caught: " + ioe));
                ioe.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.server.close();
            Thread.sleep(1000L);
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void send(String message) {
        logger.debug((Object)("RAFStack sends the following information: " + message));
        try {
            Socket socket = new Socket(this.remotehost, this.remoteport);
            logger.debug((Object)("Socket bound to " + socket.getLocalAddress() + " / " + socket.getLocalPort()));
            OutputStream out = socket.getOutputStream();
            out.write(message.getBytes());
            socket.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("IOException caught: " + ioe));
        }
    }
}

