/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.stack;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.stack.RAFStack;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;

public class RAStackThread
extends Thread {
    private static Logger logger = Logger.getLogger(RAStackThread.class);
    private Socket socket;
    private ArrayList listener;
    private RAFStack parent;

    public RAStackThread(Socket socket, RAFStack parent, ArrayList listener) {
        this.parent = parent;
        this.socket = socket;
        this.listener = listener;
    }

    private void informListeners(String incomingData) {
        for (RAFStackListener rsl : this.listener) {
            rsl.onEvent(incomingData);
        }
    }

    public void run() {
        try {
            logger.debug((Object)("Serverthread " + this.getName() + " started. "));
            byte[] b = new byte[2000];
            InputStream in = this.socket.getInputStream();
            int read = in.read(b);
            String request = new String(b, 0, read);
            logger.debug((Object)("bytes received (" + read + ") = " + request));
            this.informListeners(request);
        }
        catch (IOException io) {
            logger.error((Object)("IOException caught. " + io));
            io.printStackTrace();
        }
        logger.debug((Object)("Serverthread " + this.getName() + " finished. "));
    }
}

