/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.test.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.mobicents.slee.resource.lab.stack.RAFStack;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;

public class RAFClient
implements RAFStackListener {
    private static final String REMOTEHOST = "localhost";
    private static final int REMOTEPORT = 40000;
    private static final int LOCALPORT = 40001;
    private static Logger logger = Logger.getLogger(RAFClient.class);
    private RAFStack stack;

    public RAFClient() {
        try {
            this.stack = new RAFStack(40001, REMOTEHOST, 40000);
            this.stack.addListener(this);
            this.stack.start();
        }
        catch (IOException ioe) {
            logger.error((Object)("Caught IOException. Could not create server port! Terminating. " + ioe));
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)args[0]);
        RAFClient client = new RAFClient();
        client.cli();
    }

    private void cli() {
        try {
            String command;
            while ((command = this.getCommand()).compareTo("exit") != 0) {
                logger.debug((Object)("command = " + command));
                this.send(command.getBytes());
            }
            this.stack.shutdown();
        }
        catch (IOException ioe) {
            logger.error((Object)("Exception caught: " + ioe));
        }
    }

    private void send(byte[] command) throws IOException {
        try {
            Socket socket = new Socket(REMOTEHOST, 40000);
            logger.debug((Object)("Socket bound to " + socket.getLocalAddress() + " / " + socket.getLocalPort()));
            OutputStream out = socket.getOutputStream();
            out.write(command);
            socket.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("IOException caught: " + ioe));
            throw ioe;
        }
    }

    private String getCommand() {
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(">> ");
        try {
            line = br.readLine();
        }
        catch (Exception e) {
            logger.error((Object)("Caught Exception: " + e));
        }
        return line.toLowerCase();
    }

    public void onEvent(String incomingData) {
        System.out.println("<< " + incomingData);
        System.out.print(">> ");
    }
}

