/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.test.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.stack.RAFStack;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;

public class RAFSwingClient
extends JFrame
implements RAFStackListener {
    private static final String REMOTEHOST = "127.0.0.1";
    private static final int REMOTEPORT = 40000;
    private static final int LOCALPORT = 40001;
    private static Logger logger = Logger.getLogger(RAFSwingClient.class);
    private RAFStack stack;
    private JButton cmdAnyBtn;
    private JButton cmdEndBtn;
    private JButton cmdInitBtn;
    private JButton id100Btn;
    private JButton id101Btn;
    private JButton id102Btn;
    private JTextField inputField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea outputArea;
    private JButton sendBtn;

    public RAFSwingClient() {
        try {
            this.stack = new RAFStack(40001, REMOTEHOST, 40000);
            this.stack.addListener(this);
            this.stack.start();
        }
        catch (IOException ioe) {
            logger.error((Object)("Caught IOException. Could not create server port! Terminating. " + ioe));
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.inputField.grabFocus();
        this.setSize(new Dimension(600, 500));
        this.getRootPane().setDefaultButton(this.sendBtn);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.id100Btn = new JButton();
        this.id101Btn = new JButton();
        this.id102Btn = new JButton();
        this.cmdInitBtn = new JButton();
        this.cmdAnyBtn = new JButton();
        this.cmdEndBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.inputField = new JTextField();
        this.sendBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.outputArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("Resource Adapter Framework - Swing Test Client");
        this.jPanel1.setLayout(new GridLayout(2, 6));
        this.id100Btn.setText("ID: 100");
        this.id100Btn.setFocusable(false);
        this.id100Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.id100BtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.id100Btn);
        this.id101Btn.setText("ID: 101");
        this.id101Btn.setFocusable(false);
        this.id101Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.id101BtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.id101Btn);
        this.id102Btn.setText("ID: 102");
        this.id102Btn.setFocusable(false);
        this.id102Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.id102BtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.id102Btn);
        this.cmdInitBtn.setText("Command: INIT");
        this.cmdInitBtn.setFocusable(false);
        this.cmdInitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.cmdInitBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdInitBtn);
        this.cmdAnyBtn.setText("Command: ANY");
        this.cmdAnyBtn.setFocusable(false);
        this.cmdAnyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.cmdAnyBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdAnyBtn);
        this.cmdEndBtn.setText("Command: END");
        this.cmdEndBtn.setFocusable(false);
        this.cmdEndBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.cmdEndBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdEndBtn);
        this.jPanel1.add(this.jPanel2);
        this.inputField.setColumns(60);
        this.inputField.setMinimumSize(new Dimension(30, 20));
        this.jPanel3.add(this.inputField);
        this.sendBtn.setText("Send");
        this.sendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RAFSwingClient.this.sendBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.sendBtn);
        this.jPanel1.add(this.jPanel3);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.outputArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.outputArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void cmdEndBtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "END" : this.inputField.getText() + " END";
        this.inputField.setText(text);
    }

    private void sendBtnActionPerformed(ActionEvent evt) {
        this.stack.send(this.inputField.getText());
        this.outputArea.setText(this.outputArea.getText() + "Send -----> " + this.inputField.getText() + '\n');
        this.inputField.setText("");
        this.inputField.grabFocus();
    }

    private void cmdAnyBtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "ANY" : this.inputField.getText() + " ANY";
        this.inputField.setText(text);
    }

    private void cmdInitBtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "INIT" : this.inputField.getText() + " INIT";
        this.inputField.setText(text);
    }

    private void id101BtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "101" : this.inputField.getText() + " 101";
        this.inputField.setText(text);
    }

    private void id100BtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "100" : this.inputField.getText() + " 100";
        this.inputField.setText(text);
    }

    private void id102BtnActionPerformed(ActionEvent evt) {
        String text = this.inputField.getText().length() == 0 ? "102" : this.inputField.getText() + " 102";
        this.inputField.setText(text);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new RAFSwingClient().setVisible(true);
            }
        });
    }

    public void onEvent(String incomingData) {
        this.outputArea.setText(this.outputArea.getText() + "Received -> " + incomingData + '\n');
    }
}

