/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.lab.test.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.mobicents.slee.resource.lab.stack.RAFStack;
import org.mobicents.slee.resource.lab.stack.RAFStackListener;

public class RAFServer
implements RAFStackListener {
    private static final int LOCALPORT = 40000;
    private static final String REMOTEHOST = "localhost";
    private static final int REMOTEPORT = 40001;
    private static Logger logger = Logger.getLogger(RAFServer.class);
    private RAFStack stack;

    public RAFServer() {
        logger.info((Object)"RAFServer instantiated.");
        try {
            this.stack = new RAFStack(40000, REMOTEHOST, 40001);
        }
        catch (IOException ioe) {
            logger.error((Object)("Could not create the server stack! Terminating. " + ioe));
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)args[0]);
        RAFServer server = new RAFServer();
        server.go();
    }

    public void go() {
        this.stack.addListener(this);
        this.stack.start();
    }

    public void onEvent(String event) {
        logger.info((Object)("Event received: " + event));
        this.stack.send("And back: " + event);
    }
}

