/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.AuditEndpointResponse;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.RestartInProgressResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.Random;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.AuditConnectionHandler;
import org.mobicents.mgcp.AuditEndpointHandler;
import org.mobicents.mgcp.CreateConnectionHandler;
import org.mobicents.mgcp.DeleteConnectionHandler;
import org.mobicents.mgcp.EndpointConfigurationHandler;
import org.mobicents.mgcp.ModifyConnectionHandler;
import org.mobicents.mgcp.NotificationRequestHandler;
import org.mobicents.mgcp.NotifyHandler;
import org.mobicents.mgcp.RespUnknownHandler;
import org.mobicents.mgcp.RestartInProgressHandler;
import org.mobicents.mgcp.TransactionHandler;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpResourceAdaptor;

public class JainMgcpProviderImpl
implements JainMgcpProvider {
    private static Logger logger = Logger.getLogger(JainMgcpProviderImpl.class);
    private final MgcpResourceAdaptor ra;
    private static int MIN_TRANSACTION_HANDLE_ID = 1;
    private static int MAX_TRANSACTION_HANDLE_ID = 999999999;
    private static AtomicInteger transactionHandleCounter = new AtomicInteger(MIN_TRANSACTION_HANDLE_ID);
    private static AtomicLong callIdentifierCounter = new AtomicLong(1L);
    private static AtomicLong requestIdentifierCounter = new AtomicLong(1L);

    public JainMgcpProviderImpl(MgcpResourceAdaptor ra) {
        this.ra = ra;
    }

    public MgcpConnectionActivity getConnectionActivity(ConnectionIdentifier connectionIdentifier) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(connectionIdentifier, -1);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        try {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(connectionIdentifier, this.ra);
            handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)handle);
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (handle != null) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public MgcpConnectionActivity getConnectionActivity(int transactionHandle) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(null, transactionHandle);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        try {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(transactionHandle, this.ra);
            handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)handle);
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (handle != null) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public MgcpEndpointActivity getEndpointActivity(EndpointIdentifier endpointIdentifier) {
        MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(endpointIdentifier.toString());
        MgcpEndpointActivityImpl activity = this.ra.getMgcpActivityManager().getMgcpEndpointActivity(handle);
        if (activity != null) {
            return activity;
        }
        boolean insertedActivity = false;
        activity = new MgcpEndpointActivityImpl(this.ra, endpointIdentifier);
        try {
            this.ra.getMgcpActivityManager().putMgcpEndpointActivity(handle, activity);
            insertedActivity = true;
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)new MgcpEndpointActivityHandle(activity.getEndpointIdentifier().toString()));
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (insertedActivity) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public void addJainMgcpListener(JainMgcpListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("this provider does not support listeners");
    }

    public JainMgcpStack getJainMgcpStack() {
        return null;
    }

    public void removeJainMgcpListener(JainMgcpListener arg0) {
    }

    public void sendMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        for (JainMgcpEvent event : events) {
            if (event instanceof JainMgcpCommandEvent) {
                JainMgcpCommandEvent commandEvent = (JainMgcpCommandEvent)event;
                TransactionHandler handle = null;
                switch (commandEvent.getObjectIdentifier()) {
                    case 101: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditConnectionHandler(this.ra.getStack());
                        break;
                    }
                    case 102: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditEndpointHandler(this.ra.getStack());
                        break;
                    }
                    case 103: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending CreateConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new CreateConnectionHandler(this.ra.getStack());
                        break;
                    }
                    case 104: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending DeleteConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new DeleteConnectionHandler(this.ra.getStack());
                        break;
                    }
                    case 105: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new EndpointConfigurationHandler(this.ra.getStack());
                        break;
                    }
                    case 106: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new ModifyConnectionHandler(this.ra.getStack());
                        break;
                    }
                    case 107: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new NotificationRequestHandler(this.ra.getStack());
                        break;
                    }
                    case 108: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new NotifyHandler(this.ra.getStack());
                        break;
                    }
                    case 300: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RespUnknownHandler(this.ra.getStack());
                        break;
                    }
                    case 109: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RestartInProgressHandler(this.ra.getStack());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not send type of the message yet");
                    }
                }
                handle.send(commandEvent);
                continue;
            }
            TransactionHandler handler = this.ra.getStack().transactions.get(event.getTransactionHandle());
            if (handler == null) {
                throw new IllegalArgumentException("Unknown transaction handle: " + event.getTransactionHandle());
            }
            if (event instanceof CreateConnectionResponse) {
                this.ra.sendingCreateConnectionResponse((CreateConnectionResponse)event);
            }
            handler.send((JainMgcpResponseEvent)event);
        }
    }

    public int getUniqueTransactionHandler() {
        int next;
        int current;
        while (!transactionHandleCounter.compareAndSet(current, next = (current = transactionHandleCounter.get()) == MAX_TRANSACTION_HANDLE_ID ? MIN_TRANSACTION_HANDLE_ID : current + 1)) {
        }
        return current;
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response, JainMgcpEvent command) {
        this.ra.processMgcpResponseEvent(response, command);
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        this.ra.processMgcpCommandEvent(command);
    }

    protected void processTransactionTimeout(JainMgcpCommandEvent command) {
        this.ra.processTimeout(command);
        AuditConnectionResponse response = null;
        switch (command.getObjectIdentifier()) {
            case 101: {
                response = new AuditConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 102: {
                response = new AuditEndpointResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 103: {
                response = new CreateConnectionResponse((Object)this, ReturnCode.Transient_Error, new ConnectionIdentifier(Long.toHexString(new Random(System.currentTimeMillis()).nextLong())));
                break;
            }
            case 104: {
                response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 105: {
                response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 106: {
                response = new ModifyConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 107: {
                response = new NotificationRequestResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 108: {
                response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 300: {
                response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 109: {
                response = new RestartInProgressResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not send type of the message yet");
            }
        }
        response.setTransactionHandle(command.getTransactionHandle());
        JainMgcpEvent[] events = new JainMgcpEvent[]{response};
        this.sendMgcpEvents(events);
    }

    public CallIdentifier getUniqueCallIdentifier() {
        long current = -1L;
        boolean b = true;
        while (b) {
            current = callIdentifierCounter.get();
            if (current == Long.MAX_VALUE) {
                b = !callIdentifierCounter.compareAndSet(current, 1L);
                continue;
            }
            b = !callIdentifierCounter.compareAndSet(current, current + 1L);
        }
        return new CallIdentifier(Long.toHexString(current));
    }

    public RequestIdentifier getUniqueRequestIdentifier() {
        long current = -1L;
        boolean b = true;
        while (b) {
            current = requestIdentifierCounter.get();
            if (current == Long.MAX_VALUE) {
                b = !requestIdentifierCounter.compareAndSet(current, 1L);
                continue;
            }
            b = !requestIdentifierCounter.compareAndSet(current, current + 1L);
        }
        return new RequestIdentifier(Long.toHexString(current));
    }
}

