/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp;

import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.CreateConnectionHandler;
import org.mobicents.mgcp.DeleteConnectionHandler;
import org.mobicents.mgcp.EndpointConfigurationHandler;
import org.mobicents.mgcp.JainMgcpStackImpl;
import org.mobicents.mgcp.ModifyConnectionHandler;
import org.mobicents.mgcp.NotificationRequestHandler;
import org.mobicents.mgcp.NotifyHandler;
import org.mobicents.mgcp.RestartInProgressHandler;
import org.mobicents.mgcp.TransactionHandler;

public class MessageHandler
implements Runnable {
    private JainMgcpStackImpl stack;
    private byte[] data;
    private InetAddress address;
    private int port;
    private Logger logger = Logger.getLogger(MessageHandler.class);

    public MessageHandler(JainMgcpStackImpl stack, byte[] data, InetAddress address, int port) {
        this.stack = stack;
        this.data = data;
        this.address = address;
        this.port = port;
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() {
        Integer tid;
        TransactionHandler handler;
        String msg = new String(this.data);
        int pos = msg.indexOf("\n");
        String header = msg.substring(0, pos).trim();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message header: " + header));
        }
        String[] tokens = header.split("\\s");
        if (this.isRequest(header)) {
            String verb;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Processing command message");
            }
            if ((verb = tokens[0]).equalsIgnoreCase("crcx")) {
                CreateConnectionHandler handle = new CreateConnectionHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("mdcx")) {
                ModifyConnectionHandler handle = new ModifyConnectionHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("dlcx")) {
                DeleteConnectionHandler handle = new DeleteConnectionHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("epcf")) {
                EndpointConfigurationHandler handle = new EndpointConfigurationHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("rqnt")) {
                NotificationRequestHandler handle = new NotificationRequestHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("ntfy")) {
                NotifyHandler handle = new NotifyHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            if (verb.equalsIgnoreCase("rsip")) {
                RestartInProgressHandler handle = new RestartInProgressHandler(this.stack, this.address, this.port);
                handle.receiveCommand(msg);
                return;
            }
            this.logger.warn((Object)("Unsupported message verbose " + verb));
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Processing response message");
        }
        if ((handler = this.stack.transactions.remove(tid = Integer.decode(tokens[1]))) == null) {
            this.logger.warn((Object)("Unknown transaction :" + tid));
            return;
        }
        handler.receiveResponse(msg);
    }
}

