/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.JainMgcpStackImpl;

public abstract class TransactionHandler {
    public static final int TIMEOUT = 5000;
    private int tid;
    protected JainMgcpStackImpl stack;
    private InetAddress remoteAddress;
    private int remotePort;
    protected JainMgcpCommandEvent commandEvent;
    private Logger logger = Logger.getLogger(TransactionHandler.class);
    private static Timer timer = new Timer();
    private TransactionTimerTask timerTask;

    public TransactionHandler(JainMgcpStackImpl stack) {
        this.stack = stack;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New mgcp transaction with id " + this.tid));
        }
    }

    public TransactionHandler(JainMgcpStackImpl stack, InetAddress remoteAddress, int port) {
        this(stack);
        this.remoteAddress = remoteAddress;
        this.remotePort = port;
    }

    public void release() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Released transaction (local id=" + this.tid + "), stop timer"));
        }
        this.stack.transactions.remove(this.tid);
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public int getTID() {
        return this.tid;
    }

    protected abstract String encode(JainMgcpCommandEvent var1);

    protected abstract String encode(JainMgcpResponseEvent var1);

    protected abstract JainMgcpCommandEvent decodeCommand(String var1) throws ParseException;

    protected abstract JainMgcpResponseEvent decodeResponse(String var1) throws ParseException;

    public void send(JainMgcpCommandEvent event) {
        this.commandEvent = event;
        String domainName = event.getEndpointIdentifier().getDomainName();
        String host = null;
        int port = 0;
        int pos = domainName.indexOf(58);
        if (pos > 0) {
            port = Integer.parseInt(domainName.substring(pos + 1));
            host = domainName.substring(0, pos);
        } else {
            port = 2427;
            host = domainName;
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown endpoint " + host);
        }
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
        this.tid = event.getTransactionHandle();
        this.stack.transactions.put(this.tid, this);
        this.timerTask = new TransactionTimerTask();
        timer.schedule((TimerTask)this.timerTask, 5000L);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Send command event to " + address + ", message\n" + msg));
        }
        this.stack.send(packet);
    }

    public void send(JainMgcpResponseEvent event) {
        if (this.remoteAddress == null) {
            throw new IllegalArgumentException("Unknown orinator address");
        }
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("id=" + this.tid + ", Send response event to " + this.remoteAddress + ":" + this.remotePort + ", message\n" + msg));
        }
        this.stack.send(packet);
        this.release();
    }

    public void receiveCommand(String message) {
        JainMgcpCommandEvent event = null;
        try {
            event = this.decodeCommand(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Event decoded: " + event));
            }
        }
        catch (ParseException e) {
            this.logger.error((Object)"Coud not parse message: ", (Throwable)e);
            return;
        }
        this.tid = event.getTransactionHandle();
        this.stack.transactions.put(this.tid, this);
        this.timerTask = new TransactionTimerTask();
        timer.schedule((TimerTask)this.timerTask, 5000L);
        this.stack.provider.processMgcpCommandEvent(event);
    }

    public void receiveResponse(String message) {
        JainMgcpResponseEvent event = null;
        try {
            event = this.decodeResponse(message);
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not decode message: ", (Throwable)e);
        }
        this.tid = event.getTransactionHandle();
        this.release();
        this.stack.provider.processMgcpResponseEvent(event, (JainMgcpEvent)this.commandEvent);
    }

    public int hashCode() {
        return this.tid;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((TransactionHandler)obj).tid == this.tid;
        }
        return false;
    }

    private class TransactionTimerTask
    extends TimerTask {
        private TransactionTimerTask() {
        }

        public void run() {
            if (TransactionHandler.this.logger.isDebugEnabled()) {
                TransactionHandler.this.logger.debug((Object)("Transaction " + TransactionHandler.this.tid + " timeout"));
            }
            try {
                TransactionHandler.this.release();
                TransactionHandler.this.stack.provider.processTransactionTimeout(TransactionHandler.this.commandEvent);
            }
            catch (Exception e) {
                TransactionHandler.this.logger.error((Object)("Failed to release mgcp transaction " + TransactionHandler.this.tid), (Throwable)e);
            }
        }
    }
}

