/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.parser;

import jain.protocol.ip.mgcp.message.parms.Bandwidth;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CompressionAlgorithm;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EchoCancellation;
import jain.protocol.ip.mgcp.message.parms.EmbeddedRequest;
import jain.protocol.ip.mgcp.message.parms.EncryptionMethod;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ExtendedConnectionParm;
import jain.protocol.ip.mgcp.message.parms.GainControl;
import jain.protocol.ip.mgcp.message.parms.LocalOptionExtension;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.PacketizationPeriod;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ResourceReservation;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.message.parms.SilenceSuppression;
import jain.protocol.ip.mgcp.message.parms.TypeOfNetwork;
import jain.protocol.ip.mgcp.message.parms.TypeOfService;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;

public class Utils {
    public static synchronized EndpointIdentifier createEndpointIdentifier(String name) {
        String[] tokens = name.split("@");
        return new EndpointIdentifier(tokens[0], tokens[1]);
    }

    public static ConnectionMode createConnectionMode(String mode) {
        if (mode.equals("sendrecv")) {
            return ConnectionMode.SendRecv;
        }
        if (mode.equalsIgnoreCase("sendonly")) {
            return ConnectionMode.SendOnly;
        }
        if (mode.equalsIgnoreCase("recvonly")) {
            return ConnectionMode.RecvOnly;
        }
        if (mode.equalsIgnoreCase("confrnce")) {
            return ConnectionMode.Confrnce;
        }
        if (mode.equalsIgnoreCase("conttest")) {
            return ConnectionMode.Conttest;
        }
        if (mode.equalsIgnoreCase("data")) {
            return ConnectionMode.Data;
        }
        if (mode.equalsIgnoreCase("loopback")) {
            return ConnectionMode.Loopback;
        }
        if (mode.equalsIgnoreCase("netwloop")) {
            return ConnectionMode.Netwloop;
        }
        if (mode.equalsIgnoreCase("netwtest")) {
            return ConnectionMode.Netwtest;
        }
        return ConnectionMode.Inactive;
    }

    public static BearerInformation createBearerInformation(String text) throws ParseException {
        if (!(text = text.toLowerCase()).startsWith("e:")) {
            throw new ParseException("Bearer extensions not supported", 0);
        }
        if ((text = text.substring(text.indexOf(":") + 1).trim()).equals("a")) {
            return BearerInformation.EncMethod_A_Law;
        }
        if (text.equals("mu")) {
            return BearerInformation.EncMethod_mu_Law;
        }
        throw new ParseException("Unknown value for BearerInformation: " + text, 0);
    }

    public static LocalOptionValue[] createLocalOptions(String text) throws ParseException {
        String[] tokens = text.split(",");
        LocalOptionValue[] options = new LocalOptionValue[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            options[i] = Utils.createLocalOption(tokens[i]);
        }
        return options;
    }

    public static LocalOptionValue createLocalOption(String text) throws ParseException {
        int pos = text.indexOf(58);
        if (pos < 0) {
            throw new ParseException("Could not parse local connection option: " + text, 0);
        }
        String name = text.substring(0, pos).trim();
        String value = text.substring(pos + 1).trim();
        if (name.equalsIgnoreCase("a")) {
            return Utils.createCompressionAlgorithm(value);
        }
        if (name.equalsIgnoreCase("p")) {
            return Utils.createPacketizationPeriod(value);
        }
        if (name.equalsIgnoreCase("b")) {
            return Utils.createBandwidth(value);
        }
        if (name.equalsIgnoreCase("e")) {
            return Utils.decodeEchoCancellation(value);
        }
        if (name.equalsIgnoreCase("gc")) {
            return Utils.decodeGainControl(value);
        }
        if (name.equalsIgnoreCase("s")) {
            return Utils.decodeSilenceSuppression(value);
        }
        if (name.equalsIgnoreCase("t")) {
            return Utils.decodeTypeOfService(value);
        }
        if (name.equalsIgnoreCase("r")) {
            return Utils.decodeResourceReservation(value);
        }
        if (name.equalsIgnoreCase("k")) {
            return Utils.decodeEncryptionMethod(value);
        }
        if (name.equalsIgnoreCase("nt")) {
            return Utils.decodeTypeOfNetwork(value);
        }
        return new LocalOptionExtension(name, value);
    }

    public static CompressionAlgorithm createCompressionAlgorithm(String value) throws ParseException {
        return new CompressionAlgorithm(value.split(";"));
    }

    public static PacketizationPeriod createPacketizationPeriod(String value) throws ParseException {
        int pos = value.indexOf(45);
        if (pos < 0) {
            try {
                return new PacketizationPeriod(Integer.parseInt(value));
            }
            catch (Exception e) {
                throw new ParseException("Invalid packetization period:" + value, 0);
            }
        }
        String low = value.substring(0, pos).trim();
        String hight = value.substring(pos + 1).trim();
        try {
            return new PacketizationPeriod(Integer.parseInt(low), Integer.parseInt(hight));
        }
        catch (Exception e) {
            throw new ParseException("Invalid packetization period:" + value, 0);
        }
    }

    public static Bandwidth createBandwidth(String value) throws ParseException {
        int pos = value.indexOf(45);
        if (pos < 0) {
            try {
                return new Bandwidth(Integer.parseInt(value));
            }
            catch (Exception e) {
                throw new ParseException("Invalid packetization period:" + value, 0);
            }
        }
        String low = value.substring(0, pos).trim();
        String hight = value.substring(pos + 1).trim();
        try {
            return new Bandwidth(Integer.parseInt(low), Integer.parseInt(hight));
        }
        catch (Exception e) {
            throw new ParseException("Invalid packetization period:" + value, 0);
        }
    }

    public static EchoCancellation decodeEchoCancellation(String value) throws ParseException {
        if (value.equalsIgnoreCase("on")) {
            return EchoCancellation.EchoCancellationOn;
        }
        if (value.equalsIgnoreCase("of")) {
            return EchoCancellation.EchoCancellationOff;
        }
        throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
    }

    public static GainControl decodeGainControl(String value) throws ParseException {
        if (value.equalsIgnoreCase("auto")) {
            return new GainControl();
        }
        try {
            return new GainControl(Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
        }
    }

    public static SilenceSuppression decodeSilenceSuppression(String value) throws ParseException {
        if (value.equalsIgnoreCase("on")) {
            return SilenceSuppression.SilenceSuppressionOn;
        }
        if (value.equalsIgnoreCase("of")) {
            return SilenceSuppression.SilenceSuppressionOff;
        }
        throw new ParseException("Invalid value for SilenceSuppression :" + value, 0);
    }

    public static TypeOfService decodeTypeOfService(String value) throws ParseException {
        try {
            return new TypeOfService((byte)Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new ParseException("Invalid value for TypeOfService :" + value, 0);
        }
    }

    public static ResourceReservation decodeResourceReservation(String value) throws ParseException {
        if (value.equalsIgnoreCase("g")) {
            return ResourceReservation.Guaranteed;
        }
        if (value.equalsIgnoreCase("cl")) {
            return ResourceReservation.ControlledLoad;
        }
        if (value.equalsIgnoreCase("be")) {
            return ResourceReservation.BestEffort;
        }
        throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
    }

    public static EncryptionMethod decodeEncryptionMethod(String value) throws ParseException {
        int pos = value.indexOf(58);
        if (pos < 0) {
            throw new ParseException("Invalid value for EncryptionData: " + value, 0);
        }
        String method = value.substring(0, pos).trim();
        String key = value.substring(pos + 1).trim();
        if (method.equalsIgnoreCase("clear")) {
            return new EncryptionMethod(1, key);
        }
        if (method.equalsIgnoreCase("base64")) {
            return new EncryptionMethod(2, key);
        }
        if (method.equalsIgnoreCase("uri")) {
            return new EncryptionMethod(3, key);
        }
        throw new ParseException("Invalid value for EncryptionData: " + method, 0);
    }

    public static TypeOfNetwork decodeTypeOfNetwork(String value) throws ParseException {
        if (value.equalsIgnoreCase("in")) {
            return TypeOfNetwork.In;
        }
        if (value.equalsIgnoreCase("atm")) {
            return TypeOfNetwork.Atm;
        }
        if (value.equalsIgnoreCase("local")) {
            return TypeOfNetwork.Local;
        }
        throw new ParseException("Invalid value for TypeOfNetwork :" + value, 0);
    }

    public static RestartMethod decodeRestartMethod(String value) throws ParseException {
        if (value.equalsIgnoreCase("graceful")) {
            return RestartMethod.Graceful;
        }
        if (value.equalsIgnoreCase("forced")) {
            return RestartMethod.Forced;
        }
        if (value.equalsIgnoreCase("restart")) {
            return RestartMethod.Restart;
        }
        if (value.equalsIgnoreCase("disconnected")) {
            return RestartMethod.Disconnected;
        }
        if (value.equalsIgnoreCase("cancel-grateful")) {
            return RestartMethod.CancelGraceful;
        }
        throw new ParseException("Extension restarts not (yet) supported:" + value, 0);
    }

    public static RequestedEvent[] decodeRequestedEvents(String value) throws ParseException {
        String[] tokens = value.split(",");
        RequestedEvent[] events = new RequestedEvent[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            events[i] = Utils.decodeRequestedEvent(tokens[i]);
        }
        return events;
    }

    public static RequestedEvent decodeRequestedEvent(String value) throws ParseException {
        int pos1 = value.indexOf(40);
        int pos2 = value.indexOf(41, pos1);
        int pos3 = value.indexOf(40, pos2);
        int pos4 = value.indexOf(41, pos3);
        if (pos1 == -1) {
            return new RequestedEvent(Utils.decodeEventName(value, null), null);
        }
        if (pos3 == -1) {
            String evtName = value.substring(0, pos1);
            String actions = value.substring(pos1 + 1, pos2 - 1);
            return new RequestedEvent(Utils.decodeEventName(evtName, null), Utils.decodeRequestedActions(actions));
        }
        String evtName = value.substring(0, pos1);
        String actions = value.substring(pos1 + 1, pos2);
        String parms = value.substring(pos3 + 1, pos4);
        return new RequestedEvent(Utils.decodeEventName(evtName, parms), Utils.decodeRequestedActions(actions));
    }

    public static EventName decodeEventName(String value, String param) throws ParseException {
        String[] tokens = value.split("/");
        if (tokens.length == 1) {
            return new EventName(PackageName.AllPackages, MgcpEvent.factory((String)tokens[0]).withParm(param));
        }
        if (tokens.length == 2) {
            int pos = tokens[1].indexOf(64);
            if (pos > 0) {
                String cid = tokens[1].substring(pos + 1);
                return new EventName(PackageName.AllPackages, MgcpEvent.factory((String)tokens[0]).withParm(param), new ConnectionIdentifier(cid));
            }
            return new EventName(PackageName.factory((String)tokens[0]), MgcpEvent.factory((String)tokens[1]).withParm(param));
        }
        if (tokens.length == 3) {
            int pos = tokens[2].indexOf(64);
            if (pos < 0) {
                throw new ParseException("Invalid token " + tokens[2], 0);
            }
            String cid = tokens[1].substring(pos + 1);
            return new EventName(PackageName.factory((String)tokens[0]), MgcpEvent.factory((String)tokens[1]).withParm(param), new ConnectionIdentifier(cid));
        }
        throw new ParseException("Unexpected event name " + value, 0);
    }

    public static RequestedAction[] decodeRequestedActions(String value) throws ParseException {
        String[] tokens = value.split(",");
        RequestedAction[] actions = new RequestedAction[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            actions[i] = Utils.decodeRequestedAction(tokens[i]);
        }
        return actions;
    }

    public static RequestedAction decodeRequestedAction(String value) throws ParseException {
        if ((value = value.trim()).equalsIgnoreCase("N")) {
            return RequestedAction.NotifyImmediately;
        }
        if (value.equalsIgnoreCase("A")) {
            return RequestedAction.Accumulate;
        }
        if (value.equalsIgnoreCase("S")) {
            return RequestedAction.Swap;
        }
        if (value.equalsIgnoreCase("I")) {
            return RequestedAction.Ignore;
        }
        if (value.equalsIgnoreCase("K")) {
            return RequestedAction.KeepSignalsActive;
        }
        if (value.equalsIgnoreCase("D")) {
            return RequestedAction.TreatAccordingToDigitMap;
        }
        if (value.toLowerCase().startsWith("e")) {
            return new RequestedAction(Utils.decodeEmbeddedRequest(value));
        }
        throw new ParseException("Extension action not suported", 0);
    }

    public static EmbeddedRequest decodeEmbeddedRequest(String value) throws ParseException {
        String[] tokens = value.split(",");
        RequestedEvent[] requestedEvents = null;
        EventName[] signalEvents = null;
        DigitMap digitMap = null;
        for (int i = 0; i < tokens.length; ++i) {
            int p2;
            int p1;
            String s = tokens[i].toLowerCase();
            if (s.startsWith("r")) {
                p1 = s.indexOf(40);
                p2 = s.indexOf(41);
                s = s.substring(p1 + 1, p2);
                requestedEvents = Utils.decodeRequestedEvents(s);
                continue;
            }
            if (s.startsWith("s")) {
                p1 = s.indexOf(40);
                p2 = s.indexOf(41);
                s = s.substring(p1 + 1, p2);
                signalEvents = Utils.decodeEventNames(s);
                continue;
            }
            if (s.startsWith("d")) {
                digitMap = new DigitMap(s);
                continue;
            }
            throw new ParseException("Unexpected embedded request string:" + value, 0);
        }
        return new EmbeddedRequest(requestedEvents, signalEvents, digitMap);
    }

    public static EventName[] decodeEventNames(String value) throws ParseException {
        String[] tokens = value.split(",");
        EventName[] events = new EventName[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String name = null;
            String parm = null;
            int pos = tokens[i].indexOf(40);
            if (pos > 0) {
                name = tokens[i].substring(0, pos);
                parm = tokens[i].substring(pos + 1, tokens[i].length() - 1);
            } else {
                name = tokens[i];
            }
            events[i] = Utils.decodeEventName(name, parm);
        }
        return events;
    }

    public static synchronized String encodeEventNames(EventName[] events) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < events.length; ++i) {
            buffer.append(events[i]);
            if (i == events.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static EndpointIdentifier decodeEndpointIdentifier(String name) {
        String[] s = name.split("@");
        return new EndpointIdentifier(s[0], s[1]);
    }

    public static ReturnCode decodeReturnCode(int code) throws ParseException {
        switch (code) {
            case 530: {
                return ReturnCode.CAS_Signaling_Protocol_Error;
            }
            case 250: {
                return ReturnCode.Connection_Was_Deleted;
            }
            case 519: {
                return ReturnCode.Endpoint_Has_No_Digit_Map;
            }
            case 502: {
                return ReturnCode.Endpoint_Insufficient_Resources;
            }
            case 520: {
                return ReturnCode.Endpoint_Is_Restarting;
            }
            case 501: {
                return ReturnCode.Endpoint_Not_Ready;
            }
            case 521: {
                return ReturnCode.Endpoint_Redirected;
            }
            case 500: {
                return ReturnCode.Endpoint_Unknown;
            }
            case 512: {
                return ReturnCode.Gateway_Cannot_Detect_Requested_Event;
            }
            case 513: {
                return ReturnCode.Gateway_Cannot_Generate_Requested_Signal;
            }
            case 514: {
                return ReturnCode.Gateway_Cannot_Send_Specified_Announcement;
            }
            case 528: {
                return ReturnCode.Incompatible_Protocol_Version;
            }
            case 515: {
                return ReturnCode.Incorrect_Connection_ID;
            }
            case 526: {
                return ReturnCode.Insufficient_Bandwidth;
            }
            case 404: {
                return ReturnCode.Insufficient_Bandwidth_Now;
            }
            case 403: {
                return ReturnCode.Insufficient_Resources_Now;
            }
            case 529: {
                return ReturnCode.Internal_Hardware_Failure;
            }
            case 524: {
                return ReturnCode.Internal_Inconsistency_In_LocalConnectionOptions;
            }
            case 527: {
                return ReturnCode.Missing_RemoteConnectionDescriptor;
            }
            case 522: {
                return ReturnCode.No_Such_Event_Or_Signal;
            }
            case 401: {
                return ReturnCode.Phone_Off_Hook;
            }
            case 402: {
                return ReturnCode.Phone_On_Hook;
            }
            case 510: {
                return ReturnCode.Protocol_Error;
            }
            case 100: {
                return ReturnCode.Transaction_Being_Executed;
            }
            case 200: {
                return ReturnCode.Transaction_Executed_Normally;
            }
            case 400: {
                return ReturnCode.Transient_Error;
            }
            case 531: {
                return ReturnCode.Trunk_Group_Failure;
            }
            case 516: {
                return ReturnCode.Unknown_Call_ID;
            }
            case 525: {
                return ReturnCode.Unknown_Extension_In_LocalConnectionOptions;
            }
            case 523: {
                return ReturnCode.Unknown_Or_Illegal_Combination_Of_Actions;
            }
            case 511: {
                return ReturnCode.Unrecognized_Extension;
            }
            case 517: {
                return ReturnCode.Unsupported_Or_Invalid_Mode;
            }
            case 518: {
                return ReturnCode.Unsupported_Or_Unknown_Package;
            }
        }
        throw new ParseException("unknown response code: " + code, 0);
    }

    public static String encodeLocalConnectionOptions(LocalOptionValue[] options) {
        String msg = "L:";
        for (int i = 0; i < options.length - 1; ++i) {
            String s = options[i].toString();
            s = s.substring(0, s.indexOf("\n"));
            msg = msg + s + ",";
        }
        msg = msg + options[options.length - 1];
        return msg;
    }

    public static String encodeNotificationRequestParms(NotificationRequestParms parms) {
        int i;
        EventName[] e;
        String msg = "X:" + parms.getRequestIdentifier() + "\n";
        if (parms.getDetectEvents() != null) {
            msg = msg + "T:";
            e = parms.getDetectEvents();
            for (i = 0; i < e.length - 1; ++i) {
                msg = msg + e[i] + ",";
            }
            msg = msg + e[e.length - 1] + "\n";
        }
        if (parms.getRequestedEvents() != null) {
            msg = msg + "R:";
            e = parms.getRequestedEvents();
            for (i = 0; i < e.length - 1; ++i) {
                msg = msg + Utils.encodeRequestedEvent((RequestedEvent)e[i]) + ",";
            }
            msg = msg + Utils.encodeRequestedEvent((RequestedEvent)e[e.length - 1]) + "\n";
        }
        if (parms.getSignalRequests() != null) {
            msg = msg + "S:";
            e = parms.getSignalRequests();
            for (i = 0; i < e.length - 1; ++i) {
                msg = msg + e[i] + ",";
            }
            msg = msg + e[e.length - 1] + "\n";
        }
        if (parms.getDigitMap() != null) {
            msg = msg + "D:" + parms.getDigitMap() + "\n";
        }
        return msg;
    }

    public static String encodeRequestedEvent(RequestedEvent evt) {
        String s = evt.getEventName().getPackageName() + "/" + evt.getEventName().getEventIdentifier().getName();
        String parms = evt.getEventName().getEventIdentifier().getParms();
        RequestedAction[] actions = evt.getRequestedActions();
        if (actions != null) {
            String ac = Utils.encodeRequestedActions(actions);
            s = s + " (" + ac + ")";
        }
        if (parms != null) {
            s = s + " (" + parms + ")";
        }
        return s;
    }

    public static synchronized String encodeRequestedEvents(RequestedEvent[] evts) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < evts.length; ++i) {
            buffer.append(Utils.encodeRequestedEvent(evts[i]));
            if (i == evts.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static synchronized String encodeRequestedActions(RequestedAction[] actions) {
        String s = "";
        String d = "";
        for (int i = 0; i < actions.length; ++i) {
            d = i == 0 ? "" : ",";
            s = s + d + Utils.encodeRequestedAction(actions[i]);
        }
        return s;
    }

    public static String encodeRequestedAction(RequestedAction action) {
        return action.toString();
    }

    public static String encodeConnectionParm(ConnectionParm parm) {
        int type = parm.getConnectionParmType();
        if (type == RegularConnectionParm.JITTER) {
            return "JI=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.LATENCY) {
            return "LA=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.OCTETS_RECEIVED) {
            return "OR=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.OCTETS_SENT) {
            return "OS=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_LOST) {
            return "PL=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_RECEIVED) {
            return "PR=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_SENT) {
            return "PS=" + parm.getConnectionParmValue();
        }
        return ((ExtendedConnectionParm)parm).getConnectionParmExtensionName() + "=" + parm.getConnectionParmValue();
    }

    public static ConnectionParm decodeConnectionParm(String parm) {
        String[] tokens = parm.split("=");
        String name = tokens[0].trim();
        String value = tokens[1].trim();
        if (name.equalsIgnoreCase("JI")) {
            return new RegularConnectionParm(RegularConnectionParm.JITTER, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("LA")) {
            return new RegularConnectionParm(RegularConnectionParm.LATENCY, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("OR")) {
            return new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("OS")) {
            return new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PL")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_LOST, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PR")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_RECEIVED, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PS")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_SENT, Integer.parseInt(value));
        }
        return new ExtendedConnectionParm(name, Integer.parseInt(value));
    }

    public static String encodeConnectionParms(ConnectionParm[] parms) {
        String s = "";
        for (int i = 0; i < parms.length - 1; ++i) {
            s = s + Utils.encodeConnectionParm(parms[i]) + ",";
        }
        s = s + Utils.encodeConnectionParm(parms[parms.length - 1]);
        return s;
    }

    public static ConnectionParm[] decodeConnectionParms(String value) {
        String[] tokens = value.split(",");
        ConnectionParm[] parms = new ConnectionParm[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parms[i] = Utils.decodeConnectionParm(tokens[i].trim());
        }
        return parms;
    }

    public static ReasonCode decodeReasonCode(String value) {
        String[] tokens = value.split("\\s");
        int code = Integer.parseInt(tokens[0]);
        ReasonCode reasonCode = null;
        switch (code) {
            case 900: {
                reasonCode = ReasonCode.Endpoint_Malfunctioning;
                break;
            }
            case 901: {
                reasonCode = ReasonCode.Endpoint_Out_Of_Service;
                break;
            }
            case 0: {
                reasonCode = ReasonCode.Endpoint_State_Is_Nominal;
                break;
            }
            case 902: {
                reasonCode = ReasonCode.Loss_Of_Lower_Layer_Connectivity;
            }
        }
        return reasonCode;
    }
}

