/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.TooManyListenersException;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpResourceAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainMgcpProviderImpl
implements JainMgcpProvider {
    private Tracer tracer = null;
    private final MgcpResourceAdaptor ra;
    private JainMgcpStackProviderImpl provider;
    private MgcpStackListener listener = new MgcpStackListener();
    private HashMap<Integer, JainMgcpCommandEvent> commandsEventMap = new HashMap();

    public JainMgcpProviderImpl(MgcpResourceAdaptor ra, Tracer tracer) {
        this.ra = ra;
        this.tracer = tracer;
    }

    public void setProvider(JainMgcpStackProviderImpl provider) {
        this.provider = provider;
        if (this.provider != null) {
            try {
                this.provider.addJainMgcpListener((JainMgcpListener)this.listener);
            }
            catch (Throwable e) {
                String msg = "Couldn't register MgcpStackListener to JainMgcpStackProviderImpl";
                this.tracer.severe(msg, e);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public MgcpConnectionActivity getConnectionActivity(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier) {
        return this.getConnectionActivity(connectionIdentifier, endpointIdentifier, true);
    }

    protected MgcpConnectionActivity getConnectionActivity(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier, boolean startActivity) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(connectionIdentifier, endpointIdentifier, -1);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(connectionIdentifier, endpointIdentifier, this.ra);
        handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
        if (startActivity) {
            try {
                this.ra.getSleeEndpoint().startActivity((ActivityHandle)handle, (Object)activity, 2);
            }
            catch (Exception e) {
                String msg = "Failed to start activity";
                this.tracer.severe(msg, (Throwable)e);
                if (handle != null) {
                    this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
                }
                activity = null;
            }
        }
        return activity;
    }

    public MgcpConnectionActivity getConnectionActivity(int transactionHandle, EndpointIdentifier endpointIdentifier) {
        return this.getConnectionActivity(transactionHandle, endpointIdentifier, true);
    }

    protected MgcpConnectionActivity getConnectionActivity(int transactionHandle, EndpointIdentifier endpointIdentifier, boolean startActivity) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(null, endpointIdentifier, transactionHandle);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        if (startActivity) {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(transactionHandle, endpointIdentifier, this.ra);
            handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
            try {
                this.ra.getSleeEndpoint().startActivity((ActivityHandle)handle, (Object)activity, 2);
            }
            catch (Exception e) {
                String msg = "Failed to start activity";
                this.tracer.severe(msg, (Throwable)e);
                if (handle != null) {
                    this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
                }
                activity = null;
            }
            return activity;
        }
        return null;
    }

    public List<MgcpConnectionActivity> getConnectionActivities(EndpointIdentifier endpointIdentifier) {
        return this.ra.getMgcpActivityManager().getMgcpConnectionActivities(endpointIdentifier);
    }

    public MgcpEndpointActivity getEndpointActivity(EndpointIdentifier endpointIdentifier) {
        return this.getEndpointActivity(endpointIdentifier, true);
    }

    protected MgcpEndpointActivity getEndpointActivity(EndpointIdentifier endpointIdentifier, boolean startActivity) {
        MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(endpointIdentifier.toString());
        MgcpEndpointActivityImpl activity = this.ra.getMgcpActivityManager().getMgcpEndpointActivity(handle);
        if (activity != null) {
            return activity;
        }
        if (startActivity) {
            activity = new MgcpEndpointActivityImpl(this.ra, endpointIdentifier);
            this.ra.getMgcpActivityManager().putMgcpEndpointActivity(activity);
            try {
                this.ra.getSleeEndpoint().startActivity((ActivityHandle)handle, (Object)activity, 2);
            }
            catch (Exception e) {
                String msg = "Failed to start activity";
                this.tracer.severe(msg, (Throwable)e);
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
                activity = null;
            }
            return activity;
        }
        return null;
    }

    public void addJainMgcpListener(JainMgcpListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("this provider does not support listeners");
    }

    public JainMgcpStack getJainMgcpStack() {
        return this.provider.getJainMgcpStack();
    }

    public void removeJainMgcpListener(JainMgcpListener arg0) {
    }

    public void sendMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        for (JainMgcpEvent event : events) {
            if (event instanceof CreateConnectionResponse) {
                this.ra.sendingCreateConnectionResponse((CreateConnectionResponse)event);
            }
            if (!(event instanceof JainMgcpCommandEvent)) continue;
            this.commandsEventMap.put(event.getTransactionHandle(), (JainMgcpCommandEvent)event);
        }
        this.provider.sendMgcpEvents(events);
    }

    public int getUniqueTransactionHandler() {
        return this.provider.getUniqueTransactionHandler();
    }

    public CallIdentifier getUniqueCallIdentifier() {
        return this.provider.getUniqueCallIdentifier();
    }

    public RequestIdentifier getUniqueRequestIdentifier() {
        return this.provider.getUniqueRequestIdentifier();
    }

    void delete() {
        if (this.provider != null) {
            this.provider.removeJainMgcpListener((JainMgcpListener)this.listener);
            try {
                this.provider.getJainMgcpStack().deleteProvider((jain.protocol.ip.mgcp.JainMgcpProvider)this.provider);
            }
            catch (DeleteProviderException e) {
                e.printStackTrace();
            }
        }
    }

    private class MgcpStackListener
    implements JainMgcpExtendedListener {
        private MgcpStackListener() {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
            JainMgcpProviderImpl.this.ra.processMgcpCommandEvent(event);
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
            JainMgcpProviderImpl.this.ra.processMgcpResponseEvent(response, (JainMgcpEvent)JainMgcpProviderImpl.this.commandsEventMap.remove(response.getTransactionHandle()));
        }

        public void transactionEnded(int handle) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent command) {
            JainMgcpProviderImpl.this.ra.processRxTimeout(command);
            JainMgcpProviderImpl.this.commandsEventMap.remove(command.getTransactionHandle());
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent command) {
            JainMgcpProviderImpl.this.ra.processTxTimeout(command);
            JainMgcpProviderImpl.this.commandsEventMap.remove(command.getTransactionHandle());
        }
    }
}

