/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpActivityManager {
    private static Logger logger = Logger.getLogger(MgcpActivityManager.class);
    private String mgcpRaEntityName = null;
    private ConcurrentHashMap<MgcpEndpointActivityHandle, MgcpEndpointActivityImpl> endpointActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<MgcpConnectionActivityHandle, MgcpConnectionActivityImpl> connectionActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, MgcpConnectionActivityHandle> transactionHandle2ActivityHandleMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MgcpConnectionActivityHandle> connectionIdentifier2ActivityHandleMap = new ConcurrentHashMap();

    protected MgcpActivityManager() {
    }

    protected MgcpConnectionActivityHandle putMgcpConnectionActivity(MgcpConnectionActivityImpl activity) {
        MgcpConnectionActivityHandle handle = activity.getActivityHandle();
        if (activity.getConnectionIdentifier() != null) {
            this.connectionIdentifier2ActivityHandleMap.put(activity.getConnectionIdentifier(), handle);
        } else if (activity.getTransactionHandle() != null) {
            this.transactionHandle2ActivityHandleMap.put(activity.getTransactionHandle(), handle);
        }
        this.connectionActivities.put(handle, activity);
        return handle;
    }

    protected MgcpConnectionActivityImpl getMgcpConnectionActivity(MgcpConnectionActivityHandle handle) {
        return this.connectionActivities.get(handle);
    }

    protected List<MgcpConnectionActivity> getMgcpConnectionActivities(EndpointIdentifier endpointIdentifier) {
        List<MgcpConnectionActivity> listOfmgcpConnectionActivities = Collections.synchronizedList(new ArrayList());
        Collection<MgcpConnectionActivityImpl> connectionActivitiesColl = this.connectionActivities.values();
        for (MgcpConnectionActivityImpl mgcpConnectionActivityImpl : connectionActivitiesColl) {
            EndpointIdentifier endpointIdentifierLocal = mgcpConnectionActivityImpl.getEndpointIdentifier();
            if (endpointIdentifierLocal == null || !endpointIdentifierLocal.toString().equals(endpointIdentifier.toString())) continue;
            listOfmgcpConnectionActivities.add(mgcpConnectionActivityImpl);
        }
        return listOfmgcpConnectionActivities;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected MgcpConnectionActivityHandle updateMgcpConnectionActivity(int transactionHandle, ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier) {
        if (connectionIdentifier == null) {
            logger.warn((Object)(this.getMgcpRaEntityName() + " : update of MgcpConnectionActivity failed, connectionIdentifier is null"));
            return null;
        }
        ActivityHandle handle = this.transactionHandle2ActivityHandleMap.remove(transactionHandle);
        if (handle == null) {
            if (!logger.isDebugEnabled()) return null;
            logger.debug((Object)(this.getMgcpRaEntityName() + " : update of MgcpConnectionActivity failed, transactionHandle " + transactionHandle + " not found"));
            return null;
        }
        MgcpConnectionActivityImpl activity = this.connectionActivities.get(handle);
        if (activity == null) {
            logger.warn((Object)(this.getMgcpRaEntityName() + " : update of MgcpConnectionActivity failed, activity for connectionIdentifier " + connectionIdentifier + " not found"));
            return null;
        }
        MgcpConnectionActivityHandle connectionHandle = (MgcpConnectionActivityHandle)handle;
        this.connectionIdentifier2ActivityHandleMap.put(connectionIdentifier.toString(), connectionHandle);
        activity.setConnectionIdentifier(connectionIdentifier);
        if (endpointIdentifier == null) return connectionHandle;
        activity.setEndpointIdentifier(endpointIdentifier);
        return connectionHandle;
    }

    protected MgcpConnectionActivityHandle getMgcpConnectionActivityHandle(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier, int transactionHandle) {
        if (connectionIdentifier != null) {
            MgcpConnectionActivityHandle handle = this.connectionIdentifier2ActivityHandleMap.get(connectionIdentifier.toString());
            return handle != null ? handle : this.updateMgcpConnectionActivity(transactionHandle, connectionIdentifier, endpointIdentifier);
        }
        return this.transactionHandle2ActivityHandleMap.get(transactionHandle);
    }

    protected MgcpEndpointActivityHandle getMgcpEndpointActivityHandle(EndpointIdentifier endpointIdentifier) {
        for (MgcpEndpointActivityHandle handle : this.endpointActivities.keySet()) {
            if (!handle.getId().equals(endpointIdentifier.toString())) continue;
            return handle;
        }
        return null;
    }

    protected void putMgcpEndpointActivity(MgcpEndpointActivityImpl activity) {
        this.endpointActivities.put(activity.getActivityHandle(), activity);
    }

    protected MgcpEndpointActivityImpl getMgcpEndpointActivity(MgcpEndpointActivityHandle handle) {
        return this.endpointActivities.get(handle);
    }

    protected boolean containsMgcpEndpointActivityHandle(MgcpEndpointActivityHandle handle) {
        return this.endpointActivities.containsKey(handle);
    }

    protected void removeMgcpActivity(ActivityHandle handle) {
        if (handle instanceof MgcpConnectionActivityHandle) {
            MgcpConnectionActivityImpl activity = this.connectionActivities.remove((MgcpConnectionActivityHandle)handle);
            if (activity != null) {
                if (activity.getConnectionIdentifier() != null) {
                    if (this.connectionIdentifier2ActivityHandleMap.remove(activity.getConnectionIdentifier()) != null && logger.isDebugEnabled()) {
                        logger.debug((Object)(this.getMgcpRaEntityName() + " : removed connection identifier mapping for handle " + handle));
                    }
                } else if (this.transactionHandle2ActivityHandleMap.remove(activity.getTransactionHandle()) != null && logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getMgcpRaEntityName() + " : removed tx handle mapping for activity handle " + handle));
                }
            } else {
                logger.warn((Object)(this.getMgcpRaEntityName() + " : connection activity for handle " + handle + " not found"));
            }
        } else if (handle instanceof MgcpEndpointActivityHandle) {
            MgcpEndpointActivityImpl activity = this.endpointActivities.remove((MgcpEndpointActivityHandle)handle);
            if (activity != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getMgcpRaEntityName() + " : removed endpoint activity for handle " + handle));
                }
            } else {
                logger.warn((Object)(this.getMgcpRaEntityName() + " : endpoint activity for handle " + handle + " not found"));
            }
        }
    }

    protected boolean containsActivityHandle(ActivityHandle handle) {
        if (handle instanceof MgcpConnectionActivityHandle) {
            return this.connectionActivities.containsKey((MgcpConnectionActivityHandle)handle);
        }
        if (handle instanceof MgcpEndpointActivityHandle) {
            return this.endpointActivities.containsKey((MgcpEndpointActivityHandle)handle);
        }
        return false;
    }

    protected Object getActivity(ActivityHandle handle) {
        if (handle instanceof MgcpConnectionActivityHandle) {
            return this.connectionActivities.get((MgcpConnectionActivityHandle)handle);
        }
        if (handle instanceof MgcpEndpointActivityHandle) {
            return this.endpointActivities.get((MgcpEndpointActivityHandle)handle);
        }
        return null;
    }

    protected ActivityHandle getActivityHandle(Object activity) {
        if (activity instanceof MgcpConnectionActivityImpl) {
            MgcpConnectionActivityImpl castedActivity = (MgcpConnectionActivityImpl)activity;
            return castedActivity.getActivityHandle();
        }
        if (activity instanceof MgcpEndpointActivityImpl) {
            MgcpEndpointActivityHandle handle = ((MgcpEndpointActivityImpl)activity).getActivityHandle();
            if (this.endpointActivities.containsKey(handle)) {
                return handle;
            }
            return null;
        }
        return null;
    }

    protected String getMgcpRaEntityName() {
        return this.mgcpRaEntityName;
    }

    protected void setMgcpRaEntityName(String mgcpRaEntityName) {
        this.mgcpRaEntityName = mgcpRaEntityName;
    }
}

