/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.xmpp;

import javax.slee.facilities.Tracer;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.mobicents.slee.resource.xmpp.XmppActivityHandle;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptor;

public class XmppConnectionListener
implements PacketListener,
ConnectionListener {
    private final XmppResourceAdaptor ra;
    private final Tracer tracer;
    private final String connectionID;
    private final XmppActivityHandle handle;

    public XmppConnectionListener(XmppResourceAdaptor ra, String connectionID, XmppActivityHandle handle) {
        this.ra = ra;
        this.tracer = ra.getTracer();
        this.connectionID = connectionID;
        this.handle = handle;
    }

    public void processPacket(Packet packet) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(this.connectionID + " received packet: " + packet.toXML());
        }
        this.ra.processEvent(packet, this.handle);
    }

    public void connectionClosed() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Got notification that connection with id=" + this.connectionID + " closed. Requesting ActivityEndEvent.");
        }
        this.ra.endActivity(this.handle);
    }

    public void connectionClosedOnError(Exception e) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Got notification that connection with id=" + this.connectionID + " closed on error. Requesting ActivityEndEvent.", (Throwable)e);
        }
        this.ra.endActivity(this.handle);
    }
}

