/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.xmpp;

import java.util.Collection;
import javax.slee.facilities.Tracer;
import org.jivesoftware.smack.ComponentXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.mobicents.slee.resource.xmpp.XmppActivityHandle;
import org.mobicents.slee.resource.xmpp.XmppConnection;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptor;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptorSbbInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppResourceAdaptorSbbInterfaceImpl
implements XmppResourceAdaptorSbbInterface {
    private final XmppResourceAdaptor ra;
    private final Tracer tracer;

    public XmppResourceAdaptorSbbInterfaceImpl(XmppResourceAdaptor ra) {
        this.ra = ra;
        this.tracer = ra.getTracer();
    }

    public XmppConnection getXmppConnection(String connectionId) {
        return this.ra.getActivity(new XmppActivityHandle(connectionId));
    }

    public XmppConnection connectClient(String connectionID, String serverHost, int serverPort, String serviceName, String username, String password, String resource, Collection<Class<?>> packetFilters) throws XMPPException {
        if (connectionID == null) {
            throw new NullPointerException("null connection id");
        }
        XmppActivityHandle handle = new XmppActivityHandle(connectionID);
        if (this.ra.getActivities().get(handle) == null) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Connecting to service " + serviceName + " at " + serverHost + ":" + serverPort);
            }
            XMPPConnection connection = null;
            try {
                connection = new XMPPConnection(serverHost, serverPort, serviceName);
                this.ra.addListener(connectionID, connection, handle, packetFilters);
                connection.login(username, password, resource);
            }
            catch (Exception e) {
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Can't connect to service.");
                }
                throw new XMPPException((Throwable)e);
            }
            return this.ra.createActivity(connectionID, connection, handle);
        }
        String e = "Connection already exists!";
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info(e);
        }
        throw new XMPPException(e);
    }

    public XmppConnection connectComponent(String connectionID, String serverHost, int serverPort, String serviceName, String componentName, String componentSecret, Collection<Class<?>> packetFilters) throws XMPPException {
        if (connectionID == null) {
            throw new NullPointerException("null connection id");
        }
        XmppActivityHandle handle = new XmppActivityHandle(connectionID);
        if (this.ra.getActivities().get(handle) == null) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Opening Component XMPP connection to " + serverHost + " on port " + serverPort);
            }
            ComponentXMPPConnection connection = null;
            try {
                connection = new ComponentXMPPConnection(componentName, componentSecret, serverHost, serverPort, serviceName);
                ServiceDiscoveryManager.setIdentityName((String)"mobicents component");
                ServiceDiscoveryManager.setIdentityType((String)"mobicents");
                ServiceDiscoveryManager.setIdentityCategory((String)"component");
                this.ra.addListener(connectionID, (XMPPConnection)connection, handle, packetFilters);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("XMPP Component connected.");
                }
            }
            catch (Exception e) {
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("XMPP Component NOT connected.");
                }
                throw new XMPPException((Throwable)e);
            }
            return this.ra.createActivity(connectionID, (XMPPConnection)connection, handle);
        }
        String e = "Connection already exists!";
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info(e);
        }
        throw new XMPPException(e);
    }

    public void disconnect(String connectionID) {
        try {
            XmppActivityHandle handle = new XmppActivityHandle(connectionID);
            XmppConnection connection = this.ra.getActivities().get(handle);
            if (connection != null) {
                ((XMPPConnection)connection.getConnection()).close();
            }
        }
        catch (Exception e) {
            this.tracer.severe("Failed to disconnect connection " + connectionID, (Throwable)e);
        }
    }

    public void sendPacket(String connectionID, Packet packet) {
        try {
            XmppActivityHandle handle = new XmppActivityHandle(connectionID);
            XmppConnection connection = this.ra.getActivities().get(handle);
            if (connection != null) {
                ((XMPPConnection)connection.getConnection()).sendPacket(packet);
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine(connectionID + " sent packet: " + packet.toXML());
                }
            }
        }
        catch (Exception e) {
            this.tracer.severe("Failed to send packet on connection " + connectionID, (Throwable)e);
        }
    }
}

