/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.xmpp;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.mobicents.slee.resource.xmpp.FireableEventTypeCache;
import org.mobicents.slee.resource.xmpp.FireableEventTypeFilter;
import org.mobicents.slee.resource.xmpp.XmppActivityHandle;
import org.mobicents.slee.resource.xmpp.XmppConnection;
import org.mobicents.slee.resource.xmpp.XmppConnectionListener;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptorSbbInterfaceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppResourceAdaptor
implements ResourceAdaptor {
    private ConcurrentHashMap<XmppActivityHandle, XmppConnection> activities;
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookup;
    private XmppResourceAdaptorSbbInterfaceImpl sbbInterface;
    private ResourceAdaptorContext resourceAdaptorContext;
    private Tracer log;
    private FireableEventTypeFilter eventTypeFilter;
    private FireableEventTypeCache eventTypeCache;

    public void setResourceAdaptorContext(ResourceAdaptorContext arg0) {
        this.resourceAdaptorContext = arg0;
        this.eventLookup = arg0.getEventLookupFacility();
        this.sleeEndpoint = arg0.getSleeEndpoint();
        this.log = arg0.getTracer(this.getClass().getSimpleName());
        this.eventTypeCache = new FireableEventTypeCache(this.log);
    }

    public void raConfigure(ConfigProperties arg0) {
    }

    public void raActive() {
        this.sbbInterface = new XmppResourceAdaptorSbbInterfaceImpl(this);
        this.activities = new ConcurrentHashMap();
        this.eventTypeFilter = new FireableEventTypeFilter();
    }

    public void raStopping() {
        for (XmppConnection activity : this.activities.values()) {
            XmppActivityHandle handle = new XmppActivityHandle(activity.getConnectionId());
            ((XMPPConnection)activity.getConnection()).close();
            this.endActivity(handle);
        }
    }

    public void raInactive() {
        this.sbbInterface = null;
        this.activities = null;
        this.eventTypeFilter = null;
    }

    public void raUnconfigure() {
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
        this.eventLookup = null;
        this.sleeEndpoint = null;
        this.log = null;
        this.eventTypeCache = null;
    }

    public void raVerifyConfiguration(ConfigProperties arg0) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.sbbInterface;
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void queryLiveness(ActivityHandle arg0) {
        XmppConnection connection;
        if (this.log.isFineEnabled()) {
            this.log.fine("queryLiveness");
        }
        if ((connection = this.activities.get(arg0)) == null) {
            this.endActivity(arg0);
        }
    }

    public Object getActivity(ActivityHandle arg0) {
        return this.getActivity((XmppActivityHandle)arg0);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        if (this.log.isFineEnabled()) {
            this.log.fine("getActivityHandle");
        }
        XmppActivityHandle activityHandle = null;
        try {
            activityHandle = new XmppActivityHandle(((XmppConnection)arg0).getConnectionId());
        }
        catch (Exception e) {
            this.log.severe("Failed to get the ActivityHandle.", (Throwable)e);
        }
        return activityHandle;
    }

    public void activityEnded(ActivityHandle ah) {
        XmppConnection activity;
        if (this.log.isFineEnabled()) {
            this.log.info("Activity Ended of connection " + ah.toString());
        }
        if ((activity = this.activities.remove(ah)) != null && this.log.isFineEnabled()) {
            this.log.fine("Removed terminated activity [activity =  " + activity + "]");
            this.log.fine("active activity list = " + this.activities.size());
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void serviceActive(ReceivableService arg0) {
        this.eventTypeFilter.serviceActive(arg0);
    }

    public void serviceStopping(ReceivableService arg0) {
        this.eventTypeFilter.serviceStopping(arg0);
    }

    public void serviceInactive(ReceivableService arg0) {
        this.eventTypeFilter.serviceInactive(arg0);
    }

    public XmppConnection getActivity(XmppActivityHandle handle) {
        if (this.log.isFineEnabled()) {
            this.log.fine("get Activity with ActivityHandle " + handle.toString());
        }
        return this.activities.get(handle);
    }

    public void endActivity(ActivityHandle ah) {
        if (this.log.isFineEnabled()) {
            this.log.fine("endActivity");
        }
        try {
            this.sleeEndpoint.endActivity(ah);
        }
        catch (Throwable e) {
            this.log.severe("Failed to end activity.", e);
        }
    }

    public void processEvent(Object event, XmppActivityHandle handle) {
        FireableEventType eventType;
        if (this.log.isFineEnabled()) {
            this.log.fine("NEW XMPP-RA EVENT: " + event.getClass().getName());
        }
        if (this.eventTypeFilter.filterEvent(eventType = this.eventTypeCache.getEventType(this.eventLookup, event))) {
            if (this.log.isFineEnabled()) {
                this.log.fine("No services activated have interest in " + eventType);
            }
            return;
        }
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)handle, eventType, event, null, null);
        }
        catch (Throwable e) {
            this.log.severe("Failed to fire event.", e);
        }
    }

    void addListener(String connectionID, XMPPConnection connection, XmppActivityHandle handle, Collection<Class<?>> packetFilters) {
        XmppConnectionListener listener = new XmppConnectionListener(this, connectionID, handle);
        if (packetFilters == null) {
            connection.addPacketListener((PacketListener)listener, null);
        } else {
            for (Class<?> clazz : packetFilters) {
                connection.addPacketListener((PacketListener)listener, (PacketFilter)new PacketTypeFilter(clazz));
            }
        }
        connection.addConnectionListener((ConnectionListener)listener);
    }

    XmppConnection createActivity(String connectionID, XMPPConnection connection, XmppActivityHandle handle) throws XMPPException {
        XmppConnection activity = new XmppConnection(connectionID, (Object)connection);
        if (this.activities.putIfAbsent(handle, activity) == null) {
            try {
                this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)activity, 2);
            }
            catch (ActivityAlreadyExistsException e) {
                this.log.warning(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                this.activities.remove(handle);
                throw new XMPPException(e.getMessage(), e);
            }
        }
        return activity;
    }

    public ResourceAdaptorContext getResourceAdaptorContext() {
        return this.resourceAdaptorContext;
    }

    public Tracer getTracer() {
        return this.log;
    }

    public Map<XmppActivityHandle, XmppConnection> getActivities() {
        if (this.log.isFineEnabled()) {
            this.log.fine("getActivities");
        }
        return this.activities;
    }
}

