/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw;

import org.csapi.fw.TpDomainID;
import org.mobicents.slee.resource.parlay.fw.AuthenticationSequence;

public class FwSessionProperties {
    private static final String GET_SHARED_SECRET = "org.mobicents.fw.sharedSecret";
    private static final String DEFAULT_SHARED_SECRET = "SLEE / OSA Gateway";
    private static final String GET_AUTHENTICATION_TIMEOUT = "org.mobicents.fw.authenticationSucceededTimeout";
    private static final long DEFAULT_AUTHENTICATION_TIMEOUT = 10000L;
    private static final String GET_AUTHENTICATION_HASH = "org.mobicents.fw.authenticationHash";
    private static final String DEFAULT_AUTHENTICATION_HASH = "P_OSA_MD5";
    private static final String GET_PARLAY_FW_VERSION = "org.mobicents.fw.parlayVersion";
    private static final String DEFAULT_PARLAY_FW_VERSION = "P_PARLAY_4";
    private static final String GET_INSTANCE_ID = "org.mobicents.fw.instanceID";
    private static final int DEFAULT_INSTANCE_ID = 0;
    private static final String GET_SIGNING_ALGORITHM_CAPS = "org.mobicents.fw.signingAlgorithmCapabilityList";
    private static final String DEFAULT_SIGNING_ALGORITHM_CAPS = "NULL";
    private static final String GET_CERTIFICATE_VAULT = "org.mobicents.fw.applicationCertificateVault";
    private static final String DEFAULT_CERTIFICATE_VAULT = "." + System.getProperty("file.separator");
    private static final String GET_AUTHENTICATION_CAPS = "org.mobicents.fw.authenticationCapabilityList";
    private static final String DEFAULT_AUTHENTICATION_CAPS = "NULL,P_RSA_512,P_RSA_1024";
    private static final String GET_SSA_TIMEOUT = "org.mobicents.fw.signServiceAgreementTimeout";
    private static final long DEFAULT_SSA_TIMEOUT = 10000L;
    private static final String GET_DECRYPTION_CIPHER = "org.mobicents.fw.decryptionCipherAlgorithm";
    private static final String DEFAULT_DECRYPTION_CIPHER = "RSA/ECB/PKCS1Padding";
    private static final String GET_ENCRYPTION_CIPHER = "org.mobicents.fw.encryptionCipherAlgorithm";
    private static final String DEFAULT_ENCRYPTION_CIPHER = "RSA/ECB/PKCS1Padding";
    private static final String GET_RESPONSE_NAME = "org.mobicents.fw.responseName";
    private static final String DEFAULT_RESPONSE_NAME = "mobicents";
    private String ipInitialIOR;
    private String fwParlayVersion;
    private String authenticationCapabilityList;
    private String namingServiceIOR;
    private String ipInitialLocation;
    private String ipInitialURL;
    private String authenticationHash;
    private String sharedSecret;
    private String certificateVault;
    private String signingAlgorithmCapabilityList;
    private String decryptionCipherAlgorithm;
    private String responseName;
    private String encryptionCipherAlgorithm;
    private TpDomainID domainID;
    private AuthenticationSequence authenticationSequence = AuthenticationSequence.TRUSTED;
    private long ssaTimeout;
    private int instanceID;
    private long authenticationSucceededTimeout;

    public String getIpInitialLocation() {
        return this.ipInitialLocation;
    }

    public void setIpInitialLocation(String ipInitialLocation) {
        this.ipInitialLocation = ipInitialLocation;
    }

    public String getIpInitialURL() {
        return this.ipInitialURL;
    }

    public void setIpInitialURL(String ipInitialURL) {
        this.ipInitialURL = ipInitialURL;
    }

    public String getNamingServiceIOR() {
        return this.namingServiceIOR;
    }

    public void setNamingServiceIOR(String namingServiceIOR) {
        this.namingServiceIOR = namingServiceIOR;
    }

    public FwSessionProperties() {
        this.setProperties();
    }

    public void setProperties() {
        this.setAuthenticationCapabilityList();
        this.setAuthenticationHash();
        this.setAuthenticationSucceededTimeout();
        this.setCertificateVault();
        this.setFwParlayVersion();
        this.setInstanceID();
        this.setResponseName();
        this.setSharedSecret();
        this.setSigningAlgorithmCapabilityList();
        this.setSsaTimeout();
        this.setEncryptionCipherAlgorithm();
        this.setDecryptionCipherAlgorithm();
    }

    public String getIpInitialIOR() {
        return this.ipInitialIOR;
    }

    public void setIpInitialIOR(String ipInitialIOR) {
        this.ipInitialIOR = ipInitialIOR;
    }

    public AuthenticationSequence getAuthenticationSequence() {
        return this.authenticationSequence;
    }

    public void setAuthenticationSequence(AuthenticationSequence authenticationSequence) {
        this.authenticationSequence = authenticationSequence;
    }

    public TpDomainID getDomainID() {
        return this.domainID;
    }

    public void setDomainID(TpDomainID domainID) {
        this.domainID = domainID;
    }

    public long getSsaTimeout() {
        return this.ssaTimeout;
    }

    private void setSsaTimeout() {
        this.ssaTimeout = System.getProperty(GET_SSA_TIMEOUT) != null ? Long.getLong(System.getProperty(GET_SSA_TIMEOUT)) : 10000L;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    private void setInstanceID() {
        String iD = System.getProperty(GET_INSTANCE_ID);
        if (iD != null) {
            try {
                this.instanceID = Integer.parseInt(iD);
            }
            catch (NumberFormatException ex) {
                this.instanceID = 0;
            }
        }
    }

    public String getFwParlayVersion() {
        return this.fwParlayVersion;
    }

    private void setFwParlayVersion() {
        this.fwParlayVersion = System.getProperty(GET_PARLAY_FW_VERSION) != null ? System.getProperty(GET_PARLAY_FW_VERSION) : DEFAULT_PARLAY_FW_VERSION;
    }

    public String getAuthenticationCapabilityList() {
        return this.authenticationCapabilityList;
    }

    private void setAuthenticationCapabilityList() {
        this.authenticationCapabilityList = System.getProperty(GET_AUTHENTICATION_CAPS) != null ? System.getProperty(GET_AUTHENTICATION_CAPS) : DEFAULT_AUTHENTICATION_CAPS;
    }

    public String getAuthenticationHash() {
        return this.authenticationHash;
    }

    private void setAuthenticationHash() {
        this.authenticationHash = System.getProperty(GET_AUTHENTICATION_HASH) != null ? System.getProperty(GET_AUTHENTICATION_HASH) : DEFAULT_AUTHENTICATION_HASH;
    }

    public long getAuthenticationSucceededTimeout() {
        return this.authenticationSucceededTimeout;
    }

    private void setAuthenticationSucceededTimeout() {
        this.authenticationSucceededTimeout = System.getProperty(GET_AUTHENTICATION_TIMEOUT) != null ? Long.getLong(System.getProperty(GET_AUTHENTICATION_TIMEOUT)) : 10000L;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    private void setSharedSecret() {
        this.sharedSecret = System.getProperty(GET_SHARED_SECRET) != null ? System.getProperty(GET_SHARED_SECRET) : DEFAULT_SHARED_SECRET;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getCertificateVault() {
        return this.certificateVault;
    }

    public String getSigningAlgorithmCapabilityList() {
        return this.signingAlgorithmCapabilityList;
    }

    private void setSigningAlgorithmCapabilityList() {
        this.signingAlgorithmCapabilityList = System.getProperty(GET_SIGNING_ALGORITHM_CAPS) != null ? System.getProperty(GET_SIGNING_ALGORITHM_CAPS) : DEFAULT_SIGNING_ALGORITHM_CAPS;
    }

    private void setCertificateVault() {
        this.certificateVault = System.getProperty(GET_CERTIFICATE_VAULT) != null ? System.getProperty(GET_CERTIFICATE_VAULT) : DEFAULT_CERTIFICATE_VAULT;
    }

    public String getDecryptionCipherAlgorithm() {
        return this.decryptionCipherAlgorithm;
    }

    private void setDecryptionCipherAlgorithm() {
        this.decryptionCipherAlgorithm = System.getProperty(GET_DECRYPTION_CIPHER) != null ? System.getProperty(GET_DECRYPTION_CIPHER) : "RSA/ECB/PKCS1Padding";
    }

    public String getResponseName() {
        return this.responseName;
    }

    private void setResponseName() {
        this.responseName = System.getProperty(GET_RESPONSE_NAME) != null ? System.getProperty(GET_RESPONSE_NAME) : DEFAULT_RESPONSE_NAME;
    }

    public void setFwParlayVersion(String fwParlayVersion) {
        this.fwParlayVersion = fwParlayVersion;
    }

    public String getEncryptionCipherAlgorithm() {
        return this.encryptionCipherAlgorithm;
    }

    private void setEncryptionCipherAlgorithm() {
        this.encryptionCipherAlgorithm = System.getProperty(GET_ENCRYPTION_CIPHER) != null ? System.getProperty(GET_ENCRYPTION_CIPHER) : "RSA/ECB/PKCS1Padding";
    }
}

