/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.Marshaler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParlayMarshaler
implements Marshaler {
    private static final String FAILED_TO_UNMARSHALL_EVENT = "Failed to unmarshallEvent";
    private static final Log logger = LogFactory.getLog(ParlayMarshaler.class);

    public ByteBuffer marshalEvent(Object event, int eventID) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(b);
        out.writeObject(event);
        out.flush();
        out.close();
        return ByteBuffer.wrap(b.toByteArray());
    }

    public Object unmarshalEvent(ByteBuffer marshalledEvent, int eventID) throws IOException {
        Object result = null;
        if (marshalledEvent.hasArray()) {
            ByteArrayInputStream b = new ByteArrayInputStream(marshalledEvent.array());
            ObjectInputStream in = new ObjectInputStream(b);
            try {
                result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)FAILED_TO_UNMARSHALL_EVENT);
                throw new IOException(FAILED_TO_UNMARSHALL_EVENT);
            }
        }
        return result;
    }

    public ByteBuffer marshalHandle(ActivityHandle handle) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(b);
        out.writeObject(handle);
        out.flush();
        out.close();
        return ByteBuffer.wrap(b.toByteArray());
    }

    public ActivityHandle unmarshalHandle(ByteBuffer marshalledHandle) throws IOException {
        Object result = null;
        if (marshalledHandle.hasArray()) {
            ByteArrayInputStream b = new ByteArrayInputStream(marshalledHandle.array());
            ObjectInputStream in = new ObjectInputStream(b);
            try {
                result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)FAILED_TO_UNMARSHALL_EVENT);
                throw new IOException(FAILED_TO_UNMARSHALL_EVENT);
            }
        }
        return (ActivityHandle)result;
    }
}

