/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.cc.gccs.IpAppCall;
import org.csapi.cc.gccs.IpAppCallControlManagerPOA;
import org.csapi.cc.gccs.TpCallEventInfo;
import org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call.Call;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManager;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallAbortedHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallEventNotifyHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallNotificationContinuedHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallNotificationInterruptedHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallOverloadCeasedHandler;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.eventHandlers.CallOverloadEncounteredHandler;
import org.omg.PortableServer.POA;

public class IpAppCallControlManagerImpl
extends IpAppCallControlManagerPOA {
    private static final Log logger = LogFactory.getLog(IpAppCallControlManagerImpl.class);
    private transient CallControlManager callControlManager;
    private transient POA defaultPOA;
    private transient Executor executor;

    public IpAppCallControlManagerImpl(CallControlManager callControlManager, POA defaultPOA, Executor ipAppCallControlManagerExecutor) {
        this.callControlManager = callControlManager;
        this.defaultPOA = defaultPOA;
        this.setExecutor(ipAppCallControlManagerExecutor);
    }

    public void dispose() {
        this.callControlManager = null;
        this.defaultPOA = null;
    }

    public POA _default_POA() {
        return this.defaultPOA;
    }

    public void callAborted(int callReference) {
        CallAbortedHandler handler = new CallAbortedHandler(this.callControlManager, callReference);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callAborted");
        }
    }

    public IpAppCall callEventNotify(org.csapi.cc.gccs.TpCallIdentifier callReference, TpCallEventInfo eventInfo, int assignmentID) {
        Call call = null;
        TpCallIdentifier callIdentifier = null;
        if (eventInfo.MonitorMode.value() == 0) {
            call = this.callControlManager.getCall(callReference.CallSessionID);
            if (call == null) {
                call = this.callControlManager.createCall(callReference);
            }
            callIdentifier = call.getTpCallIdentifier();
        }
        CallEventNotifyHandler handler = new CallEventNotifyHandler(this.callControlManager, callIdentifier, eventInfo, assignmentID);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callEventNotify");
        }
        return this.callControlManager.getIpAppCall();
    }

    public void callNotificationInterrupted() {
        CallNotificationInterruptedHandler handler = new CallNotificationInterruptedHandler(this.callControlManager);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callNotificationInterrupted");
        }
    }

    public void callNotificationContinued() {
        CallNotificationContinuedHandler handler = new CallNotificationContinuedHandler(this.callControlManager);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callNotificationContinued");
        }
    }

    public void callOverloadEncountered(int assignmentID) {
        CallOverloadEncounteredHandler handler = new CallOverloadEncounteredHandler(this.callControlManager, assignmentID);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callOverloadEncountered");
        }
    }

    public void callOverloadCeased(int assignmentID) {
        CallOverloadCeasedHandler handler = new CallOverloadCeasedHandler(this.callControlManager, assignmentID);
        try {
            this.executor.execute((Runnable)handler);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted handling callOverloadCeased");
        }
    }

    private void setExecutor(Executor ipAppCallControlManagerExecutor) {
        this.executor = ipAppCallControlManagerExecutor;
    }
}

