/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_AMOUNT;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_CURRENCY;
import org.csapi.P_INVALID_EVENT_TYPE;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.P_UNSUPPORTED_ADDRESS_PLAN;
import org.csapi.TpAddress;
import org.csapi.TpAoCInfo;
import org.csapi.TpCommonExceptions;
import org.csapi.cc.TpCallAppInfo;
import org.csapi.cc.TpCallChargePlan;
import org.csapi.cc.TpCallEndedReport;
import org.csapi.cc.TpCallError;
import org.csapi.cc.TpCallEventRequest;
import org.csapi.cc.TpCallInfoReport;
import org.csapi.cc.TpReleaseCause;
import org.csapi.cc.mpccs.IpAppCallLeg;
import org.csapi.cc.mpccs.IpAppCallLegHelper;
import org.csapi.cc.mpccs.IpMultiPartyCall;
import org.csapi.cc.mpccs.TpCallLegIdentifier;
import org.csapi.cc.mpccs.TpMultiPartyCallIdentifier;
import org.mobicents.csapi.jr.slee.cc.mpccs.CallEndedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.CreateAndRouteCallLegErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.GetInfoErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.GetInfoResEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.IpCallLegConnection;
import org.mobicents.csapi.jr.slee.cc.mpccs.SuperviseErrEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.SuperviseResEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpAppCallLegImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpCallLegConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.MpccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.TpMultiPartyCallActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLeg;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLegImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall.MultiPartyCall;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.ResourceIDFactory;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.corba.ServantActivationHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.Servant;

public class MultiPartyCallImpl
implements MultiPartyCall {
    private static final String CALL_SESSION_IS_NO_LONGER_VALID = "Call session is no longer valid.";
    private static final Log logger = LogFactory.getLog(MultiPartyCallImpl.class);
    private transient MultiPartyCallControlManager multiPartyCallControlManager;
    private final transient org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier tpMultiPartyCallIdentifier;
    private transient IpAppCallLeg ipAppCallLeg;
    private transient IpAppCallLegImpl ipAppCallLegImpl;
    private final transient Map callLegMap;
    private transient IpMultiPartyCall ipMultiPartyCall;
    private final transient int callSessionID;
    private final transient ActivityManager activityManager;
    private transient MpccsListener eventListener;
    private final transient ActivityHandle activityHandle;
    private final transient Executor[] ipAppCallLegExecutors;

    public MultiPartyCallImpl(MultiPartyCallControlManager multiPartyCallControlManager, org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier tpMultiPartyCallIdentifier, IpMultiPartyCall ipMultiPartyCall, int callSessionID, ActivityManager activityManager, MpccsListener eventListener, Executor[] ipAppCallLegExecutors) {
        this.multiPartyCallControlManager = multiPartyCallControlManager;
        this.tpMultiPartyCallIdentifier = tpMultiPartyCallIdentifier;
        this.ipMultiPartyCall = ipMultiPartyCall;
        this.callSessionID = callSessionID;
        this.activityManager = activityManager;
        this.eventListener = eventListener;
        this.activityHandle = new TpMultiPartyCallActivityHandle(tpMultiPartyCallIdentifier);
        this.callLegMap = new HashMap();
        this.ipAppCallLegExecutors = ipAppCallLegExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        MultiPartyCallImpl multiPartyCallImpl = this;
        synchronized (multiPartyCallImpl) {
            this.activateIpAppCallLeg();
        }
    }

    protected void activateIpAppCallLeg() {
        this.ipAppCallLegImpl = new IpAppCallLegImpl(this, this.multiPartyCallControlManager.getIpAppCallLegPOA(), this.ipAppCallLegExecutors);
        try {
            Object object = ServantActivationHelper.activateServant(this.multiPartyCallControlManager.getIpAppCallLegPOA(), (Servant)this.ipAppCallLegImpl);
            this.ipAppCallLeg = IpAppCallLegHelper.narrow((Object)object);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate IpAppCallLeg.", (Throwable)e);
        }
    }

    public org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier getTpMultiPartyCallIdentifier() {
        return this.tpMultiPartyCallIdentifier;
    }

    public IpAppCallLeg getIpAppCallLeg() {
        return this.ipAppCallLeg;
    }

    public synchronized CallLeg getCallLeg(int callLegSessionID) {
        return (CallLeg)this.callLegMap.get(new Integer(callLegSessionID));
    }

    public synchronized void addCallLeg(int callLegSessionID, CallLeg callLeg) {
        this.callLegMap.put(new Integer(callLegSessionID), callLeg);
    }

    public synchronized CallLeg removeCallLeg(int callLegSessionID) {
        return (CallLeg)this.callLegMap.remove(new Integer(callLegSessionID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpMultiPartyCall getIpMultiPartyCall() {
        MultiPartyCallImpl multiPartyCallImpl = this;
        synchronized (multiPartyCallImpl) {
            return this.ipMultiPartyCall;
        }
    }

    public int getCallSessionID() {
        return this.callSessionID;
    }

    public ActivityHandle getActivityHandle() {
        return this.activityHandle;
    }

    public org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier[] getCallLegs() throws TpCommonExceptions, ResourceException {
        org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier[] result = null;
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                TpCallLegIdentifier[] callLegIdentifiers = multiPartyCall.getCallLegs(this.callSessionID);
                result = new org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier[callLegIdentifiers.length];
                for (int i = 0; i < callLegIdentifiers.length; ++i) {
                    result[i] = this.getCallLeg(callLegIdentifiers[i].CallLegSessionID).getTpCallLegIdentifier();
                }
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier createCallLeg() throws TpCommonExceptions, ResourceException {
        org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier result = null;
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            MultiPartyCallImpl multiPartyCallImpl = this;
            synchronized (multiPartyCallImpl) {
                try {
                    TpCallLegIdentifier callLegIdentifier = multiPartyCall.createCallLeg(this.callSessionID, this.getIpAppCallLeg());
                    CallLeg callLeg = this.createCallLeg(callLegIdentifier);
                    result = callLeg.getTpCallLegIdentifier();
                    this.activityManager.add(callLeg.getActivityHandle(), callLeg.getTpCallLegIdentifier());
                    this.activityManager.activityStartedSuspended(callLeg.getActivityHandle());
                }
                catch (P_INVALID_SESSION_ID e) {
                    logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                    throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
                }
                catch (P_INVALID_INTERFACE_TYPE e) {
                    logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                    throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier createAndRouteCallLegReq(TpCallEventRequest[] arg1, TpAddress arg2, TpAddress arg3, TpCallAppInfo[] arg4) throws TpCommonExceptions, P_INVALID_ADDRESS, P_UNSUPPORTED_ADDRESS_PLAN, P_INVALID_NETWORK_STATE, P_INVALID_EVENT_TYPE, P_INVALID_CRITERIA, ResourceException {
        org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier result = null;
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            MultiPartyCallImpl multiPartyCallImpl = this;
            synchronized (multiPartyCallImpl) {
                try {
                    TpCallLegIdentifier callLegIdentifier = multiPartyCall.createAndRouteCallLegReq(this.callSessionID, arg1, arg2, arg3, arg4, this.getIpAppCallLeg());
                    CallLeg callLeg = this.createCallLeg(callLegIdentifier);
                    result = callLeg.getTpCallLegIdentifier();
                    this.activityManager.add(callLeg.getActivityHandle(), callLeg.getTpCallLegIdentifier());
                    this.activityManager.activityStartedSuspended(callLeg.getActivityHandle());
                }
                catch (P_INVALID_SESSION_ID e) {
                    logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                    throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
                }
                catch (P_INVALID_INTERFACE_TYPE e) {
                    logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                    throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
                }
            }
        }
        return result;
    }

    public void release(TpReleaseCause arg1) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.release(this.callSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void deassignCall() throws TpCommonExceptions, ResourceException {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.deassignCall(this.callSessionID);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
            this.activityManager.remove(this.activityHandle, this.tpMultiPartyCallIdentifier);
            this.activityManager.activityEnding(this.activityHandle);
            this.dispose();
        }
    }

    public void getInfoReq(int arg1) throws TpCommonExceptions, ResourceException {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.getInfoReq(this.callSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void setChargePlan(TpCallChargePlan arg1) throws TpCommonExceptions, ResourceException {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.setChargePlan(this.callSessionID, arg1);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void setAdviceOfCharge(TpAoCInfo arg1, int arg2) throws TpCommonExceptions, ResourceException, P_INVALID_CURRENCY, P_INVALID_AMOUNT {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.setAdviceOfCharge(this.callSessionID, arg1, arg2);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void superviseReq(int arg1, int arg2) throws TpCommonExceptions, ResourceException {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            try {
                multiPartyCall.superviseReq(this.callSessionID, arg1, arg2);
            }
            catch (P_INVALID_SESSION_ID e) {
                logger.warn((java.lang.Object)(CALL_SESSION_IS_NO_LONGER_VALID + ParlayExceptionUtil.stringify(e)));
                throw new ResourceException(CALL_SESSION_IS_NO_LONGER_VALID);
            }
        }
    }

    public void getInfoRes(int arg0, TpCallInfoReport arg1) {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            GetInfoResEvent event = new GetInfoResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, arg1);
            this.eventListener.onGetInfoResEvent(event);
        }
    }

    public void getInfoErr(int arg0, TpCallError arg1) {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            GetInfoErrEvent event = new GetInfoErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, arg1);
            this.eventListener.onGetInfoErrEvent(event);
        }
    }

    public void superviseRes(int arg0, int arg1, int arg2) {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            SuperviseResEvent event = new SuperviseResEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, arg1, arg2);
            this.eventListener.onSuperviseResEvent(event);
        }
    }

    public void superviseErr(int arg0, TpCallError arg1) {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            SuperviseErrEvent event = new SuperviseErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, arg1);
            this.eventListener.onSuperviseErrEvent(event);
        }
    }

    public void callEnded(int arg0, TpCallEndedReport arg1) {
        IpMultiPartyCall multiPartyCall = this.getIpMultiPartyCall();
        if (multiPartyCall != null) {
            CallEndedEvent event = new CallEndedEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, arg1);
            this.eventListener.onCallEndedEvent(event);
            this.activityManager.remove(this.activityHandle, this.tpMultiPartyCallIdentifier);
            this.activityManager.activityEnding(this.activityHandle);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndRouteCallLegErr(int arg0, TpCallLegIdentifier arg1, TpCallError arg2) {
        IpMultiPartyCall multiPartyCall;
        CallLeg callLeg;
        MultiPartyCallImpl multiPartyCallImpl = this;
        synchronized (multiPartyCallImpl) {
            callLeg = this.getCallLeg(arg1.CallLegSessionID);
        }
        if (callLeg != null && (multiPartyCall = this.getIpMultiPartyCall()) != null) {
            CreateAndRouteCallLegErrEvent event = new CreateAndRouteCallLegErrEvent(this.multiPartyCallControlManager.getTpServiceIdentifier(), this.tpMultiPartyCallIdentifier, callLeg.getTpCallLegIdentifier(), arg2);
            this.eventListener.onCreateAndRouteCallLegErrEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MultiPartyCallImpl multiPartyCallImpl = this;
        synchronized (multiPartyCallImpl) {
            this.ipMultiPartyCall = null;
            Collection callLegs = this.callLegMap.values();
            for (CallLeg callLeg : callLegs) {
                callLeg.dispose();
            }
            this.callLegMap.clear();
            this.deactivateIpAppCallLeg();
            if (this.multiPartyCallControlManager != null) {
                this.multiPartyCallControlManager.removeMultiPartyCall(this.callSessionID);
                this.multiPartyCallControlManager = null;
            }
            this.eventListener = null;
        }
    }

    private void deactivateIpAppCallLeg() {
        if (this.ipAppCallLegImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppCallLegImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppCallLeg servant.", (Throwable)e);
            }
            this.ipAppCallLegImpl.dispose();
            this.ipAppCallLeg = null;
            this.ipAppCallLegImpl = null;
        }
    }

    private CallLeg createCallLeg(TpCallLegIdentifier corbaIdentifier) {
        int callLegReferenceID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier callLegIdentifier = new org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier(callLegReferenceID, corbaIdentifier.CallLegSessionID);
        CallLegImpl callLeg = new CallLegImpl(this.multiPartyCallControlManager, this, callLegIdentifier, corbaIdentifier.CallLegReference, corbaIdentifier.CallLegSessionID, this.activityManager, this.eventListener);
        callLeg.init();
        this.addCallLeg(corbaIdentifier.CallLegSessionID, callLeg);
        return callLeg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpCallLegConnection getIpCallLegConnection(org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier callLegIdentifier) throws ResourceException {
        CallLeg callLeg;
        MultiPartyCallImpl multiPartyCallImpl = this;
        synchronized (multiPartyCallImpl) {
            callLeg = this.getCallLeg(callLegIdentifier.getCallLegSessionID());
        }
        if (callLeg != null) {
            return new IpCallLegConnectionImpl(callLeg);
        }
        throw new ResourceException("Unrecognized TpCallLegIdentifier");
    }

    public void closeConnection() throws ResourceException {
    }

    public TpMultiPartyCallIdentifier getParlayTpMultiPartyCallIdentifier() {
        return new TpMultiPartyCallIdentifier(this.ipMultiPartyCall, this.callSessionID);
    }
}

