/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui;

import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.TpCommonExceptions;
import org.csapi.ui.IpUI;
import org.csapi.ui.TpUIError;
import org.csapi.ui.TpUIFault;
import org.csapi.ui.TpUIReport;
import org.mobicents.csapi.jr.slee.ui.SendInfoAndCollectErrEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoAndCollectResEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoErrEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoResEvent;
import org.mobicents.csapi.jr.slee.ui.TpUIIdentifier;
import org.mobicents.csapi.jr.slee.ui.UserInteractionFaultDetectedEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.TpUIActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.UiListener;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.AbstractUIImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.UIGeneric;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public class UIGenericImpl
extends AbstractUIImpl
implements UIGeneric {
    private static final Log logger = LogFactory.getLog(UIGenericImpl.class);
    private final transient IpUI ipUI;
    private final transient TpUIIdentifier tpUIIdentifier;

    public UIGenericImpl(UIManager manager, IpUI ipUI, int userInteractionSessionID, TpUIIdentifier sleeTpUIIdentifier, ActivityManager activityManager, UiListener eventListener) {
        super(manager, userInteractionSessionID, activityManager, eventListener, new TpUIActivityHandle(sleeTpUIIdentifier));
        this.ipUI = ipUI;
        this.tpUIIdentifier = sleeTpUIIdentifier;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UIGenericImpl activity created for userInteractionSessionID =[" + userInteractionSessionID + "]"));
        }
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpUI getIpUI() {
        UIGenericImpl uIGenericImpl = this;
        synchronized (uIGenericImpl) {
            return this.ipUI;
        }
    }

    public TpUIIdentifier getTpUIIdentifier() {
        return this.tpUIIdentifier;
    }

    public final void sendInfoRes(int userInteractionSessionID, int assignmentID, TpUIReport response) {
        if (this.getIpUI() != null) {
            SendInfoResEvent event = new SendInfoResEvent(this.getUiManager().getTpServiceIdentifier(), null, this.tpUIIdentifier, assignmentID, response);
            this.getEventListener().onSendInfoResEvent(event);
        }
    }

    public final void sendInfoErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUI() != null) {
            SendInfoErrEvent event = new SendInfoErrEvent(this.getUiManager().getTpServiceIdentifier(), null, this.tpUIIdentifier, assignmentID, error);
            this.getEventListener().onSendInfoErrEvent(event);
        }
    }

    public final void sendInfoAndCollectRes(int userInteractionSessionID, int assignmentID, TpUIReport response, String collectedInfo) {
        if (this.getIpUI() != null) {
            SendInfoAndCollectResEvent event = new SendInfoAndCollectResEvent(this.getUiManager().getTpServiceIdentifier(), null, this.tpUIIdentifier, assignmentID, response, collectedInfo);
            this.getEventListener().onSendInfoAndCollectResEvent(event);
        }
    }

    public final void sendInfoAndCollectErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUI() != null) {
            SendInfoAndCollectErrEvent event = new SendInfoAndCollectErrEvent(this.getUiManager().getTpServiceIdentifier(), null, this.tpUIIdentifier, assignmentID, error);
            this.getEventListener().onSendInfoAndCollectErrEvent(event);
        }
    }

    public final void userInteractionFaultDetected(int userInteractionSessionID, TpUIFault fault) {
        if (this.getIpUI() != null) {
            UserInteractionFaultDetectedEvent event = new UserInteractionFaultDetectedEvent(this.getUiManager().getTpServiceIdentifier(), null, this.tpUIIdentifier, fault);
            this.getEventListener().onUserInteractionFaultDetectedEvent(event);
            this.getActivityManager().remove(this.getActivityHandle(), this.tpUIIdentifier);
            this.getActivityManager().activityEnding(this.getActivityHandle());
            this.dispose();
        }
    }

    public final void release() throws TpCommonExceptions, ResourceException {
        IpUI ui = this.getIpUI();
        try {
            ui.release(this.getUserInteractionSessionID());
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)("UI session is no longer valid." + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException("UI session is no longer valid.");
        }
        this.getActivityManager().remove(this.getActivityHandle(), this.tpUIIdentifier);
        this.getActivityManager().activityEnding(this.getActivityHandle());
        this.dispose();
    }
}

