/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw.access;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.csapi.IpInterface;
import org.csapi.P_INVALID_INTERFACE_NAME;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.TpCommonExceptions;
import org.csapi.fw.P_ACCESS_DENIED;
import org.csapi.fw.P_INVALID_PROPERTY;
import org.csapi.fw.P_INVALID_SIGNATURE;
import org.csapi.fw.P_NO_ACCEPTABLE_SIGNING_ALGORITHM;
import org.csapi.fw.TpAuthDomain;
import org.csapi.fw.TpDomainID;
import org.csapi.fw.TpDomainIDType;
import org.csapi.fw.TpProperty;
import org.csapi.fw.fw_access.trust_and_security.IpAccess;
import org.csapi.fw.fw_access.trust_and_security.IpClientAPILevelAuthentication;
import org.csapi.fw.fw_access.trust_and_security.IpClientAPILevelAuthenticationHelper;
import org.csapi.fw.fw_access.trust_and_security.IpClientAccess;
import org.csapi.fw.fw_access.trust_and_security.IpClientAccessHelper;
import org.csapi.fw.fw_access.trust_and_security.IpInitial;
import org.csapi.fw.fw_application.discovery.IpServiceDiscovery;
import org.csapi.fw.fw_application.discovery.IpServiceDiscoveryHelper;
import org.csapi.fw.fw_application.service_agreement.IpAppServiceAgreementManagement;
import org.csapi.fw.fw_application.service_agreement.IpServiceAgreementManagement;
import org.csapi.fw.fw_application.service_agreement.IpServiceAgreementManagementHelper;
import org.mobicents.csapi.jr.slee.fw.TerminateAccessEvent;
import org.mobicents.slee.resource.parlay.fw.AuthenticationSequence;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.fw.FwSessionProperties;
import org.mobicents.slee.resource.parlay.fw.access.AuthenticationHandler;
import org.mobicents.slee.resource.parlay.fw.access.AuthenticationHandlerImpl;
import org.mobicents.slee.resource.parlay.fw.access.IpClientAPILevelAuthenticationImpl;
import org.mobicents.slee.resource.parlay.fw.access.IpClientAccessImpl;
import org.mobicents.slee.resource.parlay.fw.access.TSMBean;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanConstants;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanException;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanListener;
import org.mobicents.slee.resource.parlay.fw.application.SABean;
import org.mobicents.slee.resource.parlay.fw.application.SABeanException;
import org.mobicents.slee.resource.parlay.fw.application.SABeanImpl;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.corba.IpInitialHelper;
import org.mobicents.slee.resource.parlay.util.corba.ORBHandler;
import org.mobicents.slee.resource.parlay.util.corba.POAFactory;
import org.mobicents.slee.resource.parlay.util.corba.PolicyFactory;
import org.mobicents.slee.resource.parlay.util.corba.ServantActivationHelper;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtilException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class TSMBeanImpl
implements Serializable,
TSMBeanConstants,
TSMBean {
    private String clientID = null;
    private TpDomainID clientDomainID = null;
    private transient Vector TSMBeanListeners = null;
    private int state = 0;
    private SABean saBean = null;
    private IpInitial initial = null;
    private IpAccess access = null;
    private IpServiceDiscovery serviceDiscovery = null;
    private IpClientAPILevelAuthenticationImpl ipClientAPILevelAuthenticationImpl = null;
    private IpClientAPILevelAuthentication ipClientAPILevelAuthentication = null;
    private IpClientAccessImpl ipClientAccessImpl = null;
    private IpClientAccess clientAccess = null;
    private POA ipClientAPILevelAuthenticationPOA = null;
    private String encryptionMethod = null;
    private java.lang.Object authenticationMonitor = new java.lang.Object();
    private boolean fwAuthenticationSucceeded = false;
    private boolean clean = false;
    private Executor eventsQueue = null;
    private ORBHandler orbHandler = null;
    private FwSessionProperties fwProperties = null;
    private static final String TERMINATION_TEXT = "TSMBean terminating service agreement";
    private String signingAlgorithm = "NULL";
    private AuthenticationHandler authHandler = null;
    private static final Log logger = LogFactory.getLog(TSMBeanImpl.class);
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String EXCEPTION_INVOKING = "Exception invoking ";
    private static final String ACCESS = "org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess";
    private static final String OBTAIN_INTERFACE = ".obtainInterface";
    private static final String OBTAIN_INTERFACE_WITH_CALLBACK = ".obtainInterfaceWithCallback";
    private static final String RELEASE_INTERFACE = ".releaseInterface";
    private static final String RELINQUISH_INTERFACE = ".relinquishInterface";
    private static final String SELECT_SIGNING_ALGORITHM = ".selectSigningAlgorithm";
    private static final String END_ACCESS = ".endAccess()";
    private static final String TERMINATE_ACCESS = ".terminateAccess()";
    private static final String INVOKING = "Invoking ";
    private static final String INVOKED = "Invoked ";
    private static final String NULL = "NULL";
    private static final String INTERFACE_NAME = "Interface Name = ";
    private static final String CLIENTAPI_EXCEPTION = "Exception creating IpClientAPILevelAuthentication";
    private static final String CLIENTACCESS_EXCEPTION = "Exception creating IpClientAccess";
    private static final String ACCESSNULL_EXCEPTION = "IpAccess ref is null.";
    private static final int MAX_WAIT_AUTHENTICATION_SUCCEEDED = 5;
    private static String version = "NULL";
    private FwSession fwSession = null;
    private TpAuthDomain tpAuthDomain = null;

    public TSMBeanImpl(FwSession fwSession, FwSessionProperties fwProperties) {
        this.fwSession = fwSession;
        this.fwProperties = fwProperties;
        this.setClientDomainID(fwProperties.getDomainID());
    }

    public void initialize() throws TSMBeanException {
        if (this.state != 0) {
            StringBuffer errorMessage = new StringBuffer("This object can only be initialized when in the IDLE_STATE.");
            errorMessage.append(this.getStateMessage());
            throw new IllegalStateException(errorMessage.toString());
        }
        if (this.getClientDomainID() == null) {
            StringBuffer errorMessage = new StringBuffer("DomainID must be specified before initialisation.");
            errorMessage.append(this.getStateMessage());
            throw new IllegalStateException(errorMessage.toString());
        }
        this.initialiseCorbaServer();
        this.setAuthenticationSequence(this.fwProperties.getAuthenticationSequence());
        try {
            this.ipClientAPILevelAuthenticationImpl = new IpClientAPILevelAuthenticationImpl();
            this.ipClientAPILevelAuthenticationImpl.setTSMBean(this);
            this.ipClientAPILevelAuthenticationPOA = POAFactory.createPOA(this.orbHandler.getRootPOA(), "IpClientAPILevelAuthentication", this.orbHandler.getRootPOA().the_POAManager(), PolicyFactory.createTransientPoaPolicies(this.orbHandler.getRootPOA()));
            Object activatedCallback = null;
            activatedCallback = ServantActivationHelper.activateServant(this.ipClientAPILevelAuthenticationPOA, (Servant)this.ipClientAPILevelAuthenticationImpl);
            this.ipClientAPILevelAuthentication = IpClientAPILevelAuthenticationHelper.narrow((Object)activatedCallback);
            this.tpAuthDomain = new TpAuthDomain(this.clientDomainID, (IpInterface)this.ipClientAPILevelAuthentication);
        }
        catch (WrongPolicy e) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)CLIENTAPI_EXCEPTION, (Throwable)e);
            }
            throw new TSMBeanException(CLIENTAPI_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        catch (ServantAlreadyActive e) {
            throw new TSMBeanException(CLIENTAPI_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        catch (ObjectAlreadyActive e) {
            throw new TSMBeanException(CLIENTAPI_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        catch (AdapterAlreadyExists e) {
            throw new TSMBeanException(CLIENTAPI_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        catch (InvalidPolicy e) {
            throw new TSMBeanException(CLIENTAPI_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        try {
            this.ipClientAccessImpl = new IpClientAccessImpl(this.fwSession.getRootPOA(), this);
            this.clientAccess = IpClientAccessHelper.narrow((Object)this.fwSession.getRootPOA().servant_to_reference((Servant)this.ipClientAccessImpl));
        }
        catch (ServantNotActive e) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)CLIENTACCESS_EXCEPTION, (Throwable)e);
            }
            throw new TSMBeanException(CLIENTACCESS_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        catch (WrongPolicy e) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)CLIENTACCESS_EXCEPTION, (Throwable)e);
            }
            throw new TSMBeanException(CLIENTACCESS_EXCEPTION, (Exception)((java.lang.Object)e));
        }
        this.eventsQueue = new QueuedExecutor();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Registering the security provider ...");
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.traceSecurityProviders();
        version = this.fwProperties.getFwParlayVersion();
        try {
            RSAUtil.loadKeyStore(this.getFwProperties().getCertificateVault(), "mobicents-parlay-ra.jks");
        }
        catch (RSAUtilException e) {
            logger.error((java.lang.Object)"RSAUtilException, keyStore not loaded properly", (Throwable)e);
        }
        this.authHandler = new AuthenticationHandlerImpl(this);
        this.state = 3;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"INITIALIZED ".concat(this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseCorbaServer() throws TSMBeanException {
        try {
            this.orbHandler = ORBHandler.getInstance();
        }
        catch (IOException e) {
            logger.error((java.lang.Object)"Failed to create ORBHandler.");
            throw new TSMBeanException("Failed to create ORBHandler.", e);
        }
        ORBHandler oRBHandler = this.orbHandler;
        synchronized (oRBHandler) {
            try {
                this.orbHandler.init();
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to initialise corba server.", (Throwable)e);
                throw new TSMBeanException("Failed to initialise corba server.", (Exception)((java.lang.Object)e));
            }
            for (int numberOfRetries = 20; !this.orbHandler.getIsServerReady() && numberOfRetries > 0; --numberOfRetries) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)"Waiting for orb to initialise ...");
                    }
                    this.orbHandler.wait(2000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((java.lang.Object)"Wait interrupted.");
                }
            }
        }
        if (!this.orbHandler.getIsServerReady()) {
            throw new TSMBeanException("Failed to initialise ORB.");
        }
    }

    private String getStateMessage() {
        StringBuffer errorMessage = new StringBuffer("Current state = ");
        switch (this.state) {
            case 0: {
                errorMessage.append("IDLE_STATE");
                break;
            }
            case 3: {
                errorMessage.append("INITIALIZED_STATE");
                break;
            }
            case 2: {
                errorMessage.append("INVALID_STATE");
                break;
            }
            case 1: {
                errorMessage.append("ACTIVE_STATE");
                break;
            }
            default: {
                errorMessage.append("UNKNOWN");
            }
        }
        return errorMessage.toString();
    }

    public String toString() {
        StringBuffer value = new StringBuffer("TSMBean");
        value.append(lineSeparator);
        if (this.clientDomainID != null) {
            value.append("ClientDomainID = ");
            if (this.clientDomainID != null) {
                value.append(this.getClientID());
            } else {
                value.append(NULL);
            }
            value.append(lineSeparator);
            value.append(this.getStateMessage()).append(lineSeparator);
            value.append("InstanceID = ").append(this.fwProperties.getInstanceID()).append(lineSeparator);
        }
        return value.toString();
    }

    public synchronized void setClientDomainID(TpDomainID newClientDomainID) {
        if (this.state == 1 || this.state == 2) {
            StringBuffer errorMessage = new StringBuffer("Client Domain can only be changed when this object's state is IDLE_STATE or INTITIALIZED_STATE. ");
            errorMessage.append(this.getStateMessage());
            throw new IllegalStateException(errorMessage.toString());
        }
        this.clientDomainID = newClientDomainID;
        this.clientID = this.getClientDomain(newClientDomainID);
    }

    public String getClientDomain(TpDomainID clientDomainID) {
        String clientID = null;
        if (clientDomainID.discriminator().equals(TpDomainIDType.P_CLIENT_APPLICATION)) {
            clientID = clientDomainID.ClientAppID();
        } else if (clientDomainID.discriminator().equals(TpDomainIDType.P_SERVICE_SUPPLIER)) {
            clientID = clientDomainID.ServiceSupplierID();
        } else if (clientDomainID.discriminator().equals(TpDomainIDType.P_FW)) {
            clientID = clientDomainID.FwID();
        } else if (clientDomainID.discriminator().equals(TpDomainIDType.P_ENT_OP)) {
            clientID = clientDomainID.EntOpID();
        } else if (clientDomainID.discriminator().equals(TpDomainIDType.P_SERVICE_INSTANCE)) {
            clientID = clientDomainID.ServiceID();
        }
        if (clientID == null) {
            StringBuffer errorMessage = new StringBuffer("Null client domain not allowed.");
            errorMessage.append(this.getStateMessage());
            throw new IllegalArgumentException(errorMessage.toString());
        }
        return clientID;
    }

    public TpDomainID getClientDomainID() {
        return this.clientDomainID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        this.state = newState;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public IpInitial getInitial() {
        return this.initial;
    }

    public java.lang.Object getAuthenticationMonitor() {
        return this.authenticationMonitor;
    }

    public void setFwAuthenticationSucceeded(boolean value) {
        this.fwAuthenticationSucceeded = value;
    }

    public void shutdown() {
        this.cleanup();
        if (this.orbHandler != null) {
            this.orbHandler.shutdown();
        }
    }

    public synchronized void authenticate() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.authenticate() called.");
        }
        if (this.getState() != 3) {
            logger.warn((java.lang.Object)"Can only authenticate when in the INTITIALIZED_STATE state.");
            throw new IllegalStateException("Can only authenticate when in the INTITIALIZED_STATE state.");
        }
        this.authenticateWithGateway();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Changing TSMBean state to ACTIVE_STATE.");
        }
        this.setState(1);
    }

    private void authenticateWithGateway() throws TSMBeanException {
        block6: {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Authenticating with Gateway ...");
            }
            try {
                if (this.initial == null) {
                    this.createInitial(this.fwProperties);
                }
                if (version.startsWith("P_PARLAY_4")) {
                    this.authenticateWithP4Gateway(this.tpAuthDomain, version);
                    break block6;
                }
                if (version.equalsIgnoreCase(NULL) || version.startsWith("P_PARLAY_3")) {
                    this.authenticateWithP3Gateway(this.tpAuthDomain);
                    break block6;
                }
                logger.error((java.lang.Object)"INVALID PARLAY VERSION, AUTHENTICATION FAILED, ABORTING");
                throw new TSMBeanException("INVALID PARLAY VERSION: " + version);
            }
            catch (TSMBeanException ex) {
                logger.error((java.lang.Object)("INVALIDATING " + this.toString()));
                this.cleanup();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticateWithP3Gateway(TpAuthDomain tpAuthDomain) throws TSMBeanException {
        this.authHandler.initiateAuthentication(tpAuthDomain);
        try {
            if (!this.getFwProperties().getAuthenticationSequence().equals(AuthenticationSequence.TRUSTED)) {
                java.lang.Object object = this.getAuthenticationMonitor();
                synchronized (object) {
                    this.encryptionMethod = this.authHandler.selectEncryptionMethod(this.fwProperties.getAuthenticationCapabilityList());
                }
                this.authHandler.authenticate(this.encryptionMethod);
                this.authHandler.authenticationSucceeded();
            }
            this.waitForAuthenticationSucceeded();
            this.access = this.authHandler.requestAccess((IpInterface)this.clientAccess);
        }
        catch (TSMBeanException ex) {
            logger.error((java.lang.Object)"AUTHENTICATION FAILED, ABORTING", (Throwable)ex);
            this.abortAuthentication();
            this.cleanup();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticateWithP4Gateway(TpAuthDomain tpAuthDomain, String version) throws TSMBeanException {
        this.authHandler.initiateAuthenticationWithVersion(tpAuthDomain, version);
        String authMechanism = null;
        if (this.getFwProperties().getAuthenticationSequence().equals(AuthenticationSequence.TRUSTED)) {
            throw new TSMBeanException("'TRUSTED' Authentication Sequence not valid for Parlay version.");
        }
        try {
            java.lang.Object object = this.getAuthenticationMonitor();
            synchronized (object) {
                authMechanism = this.authHandler.selectAuthenticationMechanism(this.fwProperties.getAuthenticationHash());
            }
            this.authHandler.challenge(authMechanism);
            this.authHandler.authenticationSucceeded();
            this.waitForAuthenticationSucceeded();
            this.access = this.authHandler.requestAccess((IpInterface)this.clientAccess);
            this.signingAlgorithm = this.selectSigningAlgorithm();
        }
        catch (TSMBeanException ex) {
            logger.error((java.lang.Object)"AUTHENTICATION FAILED, ABORTING", (Throwable)ex);
            this.abortAuthentication();
            if (this.authHandler != null) {
                this.authHandler.cleanup();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAuthenticationSucceeded() throws TSMBeanException {
        int waitAttempts = 0;
        while (!this.fwAuthenticationSucceeded) {
            if (waitAttempts < 5) {
                java.lang.Object object = this.getAuthenticationMonitor();
                synchronized (object) {
                    block8: {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((java.lang.Object)"Waiting for authenticationSucceeded() message.");
                            }
                            ++waitAttempts;
                            this.getAuthenticationMonitor().wait(this.fwProperties.getAuthenticationSucceededTimeout());
                        }
                        catch (InterruptedException ex) {
                            if (!logger.isDebugEnabled()) break block8;
                            logger.debug((java.lang.Object)"Interrupted waiting for gateway authenticationSucceeded message");
                        }
                    }
                    continue;
                }
            }
            throw new TSMBeanException("Failed to receive authenticationSucceeded.");
        }
    }

    private void createInitial(FwSessionProperties properties) throws TSMBeanException {
        if (properties.getIpInitialIOR() != null && !properties.getIpInitialIOR().equals("")) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Resolving IpInitial from IOR.");
            }
            this.initial = org.csapi.fw.fw_access.trust_and_security.IpInitialHelper.narrow((Object)this.orbHandler.getOrb().string_to_object(properties.getIpInitialIOR()));
        } else {
            if (properties.getNamingServiceIOR() != null && !properties.getNamingServiceIOR().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Resolving IpInitial from NameService.");
                }
                try {
                    this.initial = IpInitialHelper.getIpInitialFromNamingService(this.orbHandler.getOrb(), properties.getNamingServiceIOR(), properties.getIpInitialLocation());
                }
                catch (UserException e) {
                    throw new TSMBeanException("Failed to get IpInitial from NameService.", (Exception)((java.lang.Object)e));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Resolving IpInitial from URL.");
            }
            try {
                this.initial = IpInitialHelper.getIpInitialfromURL(this.orbHandler.getOrb(), properties.getIpInitialURL());
            }
            catch (UserException e) {
                throw new TSMBeanException("Failed to get IpInitial from URL.", (Exception)((java.lang.Object)e));
            }
            catch (IOException e) {
                throw new TSMBeanException("Failed to get IpInitial from URL.", e);
            }
        }
        if (this.initial == null) {
            logger.error((java.lang.Object)"Factory returned a null IpInitial object.");
            throw new TSMBeanException("Factory returned a null IpInitial object.");
        }
    }

    private void abortAuthentication() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Aborting authentication");
        }
        if (this.authHandler != null) {
            this.authHandler.abortAuthentication();
        }
    }

    public synchronized void endAccess(TpProperty[] endAccessProperties) throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.endAccess() called.");
        }
        if (this.getState() != 1) {
            logger.warn((java.lang.Object)"Can only endAccess when in the ACTIVE_STATE state.");
            throw new IllegalStateException("Can only endAccess when in the ACTIVE_STATE state.");
        }
        if (this.access == null) {
            logger.warn((java.lang.Object)ACCESSNULL_EXCEPTION);
            throw new TSMBeanException(ACCESSNULL_EXCEPTION);
        }
        try {
            if (version.equalsIgnoreCase(NULL) || version.startsWith("P_PARLAY_3")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()");
                }
                this.access.endAccess(endAccessProperties);
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()");
                }
            } else if (version.startsWith("P_PARLAY_4")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()");
                }
                this.terminateAccessWithGateway();
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()");
                }
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_PROPERTY ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.endAccess()", (Exception)((java.lang.Object)ex));
        }
        this.setState(2);
    }

    private synchronized void terminateAccessWithGateway() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Terminating access with Gateway ...");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()");
            }
            this.access.terminateAccess(TERMINATION_TEXT, this.generateDigitalSignature(TERMINATION_TEXT));
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_SIGNATURE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.terminateAccess()", (Exception)((java.lang.Object)ex));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IpServiceDiscovery obtainDiscoveryInterface() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.obtainDiscoveryInterface() called.");
        }
        IpServiceDiscovery result = null;
        if (this.getState() == 1) {
            if (this.serviceDiscovery != null) return this.serviceDiscovery;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface");
                    logger.debug((java.lang.Object)"Interface Name = P_DISCOVERY");
                }
                IpInterface ipInterface = this.access.obtainInterface("P_DISCOVERY");
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface");
                }
                this.serviceDiscovery = IpServiceDiscoveryHelper.narrow((Object)ipInterface);
                if (!logger.isDebugEnabled()) return this.serviceDiscovery;
                logger.debug((java.lang.Object)"Narrowed IpServiceDiscovery");
                return this.serviceDiscovery;
            }
            catch (TpCommonExceptions ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface", (Exception)((java.lang.Object)ex));
            }
            catch (P_ACCESS_DENIED ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface", (Exception)((java.lang.Object)ex));
            }
            catch (P_INVALID_INTERFACE_NAME ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface", (Exception)((java.lang.Object)ex));
            }
            catch (SystemException ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterface", (Exception)((java.lang.Object)ex));
            }
        }
        logger.warn((java.lang.Object)"Can only obtainDiscoveryInterface() when in the ACTIVE_STATE state.");
        throw new IllegalStateException("Can only obtainDiscoveryInterface() when in the ACTIVE_STATE state.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void releaseDiscoveryInterface() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.releaseDiscoverInterface() called.");
        }
        if (this.getState() != 1) {
            logger.warn((java.lang.Object)"Can only releaseDiscoveryInterface when in the ACTIVE_STATE state.");
            throw new IllegalStateException("Can only releaseDiscoveryInterface when in the ACTIVE_STATE state.");
        }
        if (this.serviceDiscovery == null) {
            logger.warn((java.lang.Object)"There is no serviceDiscovery interface to release.");
            throw new TSMBeanException("There is no serviceDiscovery interface to release.");
        }
        if (version.equalsIgnoreCase(NULL)) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface");
                    logger.debug((java.lang.Object)"Interface Name = P_DISCOVERY");
                }
                this.access.releaseInterface("P_DISCOVERY");
                if (!logger.isDebugEnabled()) return;
                logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface");
                return;
            }
            catch (TpCommonExceptions ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface", (Exception)((java.lang.Object)ex));
            }
            catch (P_ACCESS_DENIED ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface", (Exception)((java.lang.Object)ex));
            }
            catch (P_INVALID_INTERFACE_NAME ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface", (Exception)((java.lang.Object)ex));
            }
            catch (SystemException ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
                throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface", (Exception)((java.lang.Object)ex));
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface");
                logger.debug((java.lang.Object)"Interface Name = P_DISCOVERY");
            }
            this.access.relinquishInterface("P_DISCOVERY", TERMINATION_TEXT, this.generateDigitalSignature(TERMINATION_TEXT));
            if (!logger.isDebugEnabled()) return;
            logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface");
            return;
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_INTERFACE_NAME ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_SIGNATURE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.relinquishInterface", (Exception)((java.lang.Object)ex));
        }
    }

    public byte[] generateDigitalSignature(String text) throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Generating a digital signature.");
            logger.debug((java.lang.Object)("Text = " + text));
            logger.debug((java.lang.Object)("Algorithm = " + this.signingAlgorithm));
        }
        PrivateKey privateKey = null;
        byte[] result = new byte[]{};
        Signature signature = null;
        if (this.signingAlgorithm.equals("P_MD5_RSA_512") || this.signingAlgorithm.equals("P_MD5_RSA_1024")) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Using DigestInfo to generate Digital Signature");
            }
            try {
                signature = Signature.getInstance("MD5withRSA");
                signature.initSign(privateKey);
                signature.update(text.getBytes("ISO-8859-1"));
                result = signature.sign();
            }
            catch (NoSuchAlgorithmException ex) {
                logger.error((java.lang.Object)"NoSuchAlgorithmException caught:", ex.fillInStackTrace());
            }
            catch (InvalidKeyException ex) {
                logger.error((java.lang.Object)"InvalidKeyException caught:", ex.fillInStackTrace());
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((java.lang.Object)"UnsupportedEncodingException caught:", ex.fillInStackTrace());
            }
            catch (SignatureException ex) {
                logger.error((java.lang.Object)"SignatureException caught:", ex.fillInStackTrace());
            }
        } else {
            try {
                result = this.signingAlgorithm.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((java.lang.Object)"UnsupportedEncodingException caught generating digital signature.", (Throwable)e);
            }
        }
        return result;
    }

    public synchronized String selectSigningAlgorithm() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"selectSigningAlgorithm()");
        }
        try {
            this.signingAlgorithm = this.access.selectSigningAlgorithm(this.getFwProperties().getSigningAlgorithmCapabilityList());
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("signing algorithm received: " + this.signingAlgorithm));
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm", (Exception)((java.lang.Object)ex));
        }
        catch (P_NO_ACCEPTABLE_SIGNING_ALGORITHM ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.selectSigningAlgorithm", (Exception)((java.lang.Object)ex));
        }
        return this.signingAlgorithm;
    }

    public synchronized SABean getSABean() {
        return this.saBean;
    }

    public synchronized SABean createSABean() throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.createSABean() called.");
        }
        if (this.getState() == 1) {
            if (this.saBean == null) {
                try {
                    this.saBean = new SABeanImpl(this);
                    this.saBean.initialise();
                }
                catch (SABeanException e) {
                    logger.error((java.lang.Object)("Exception creating SABean" + e));
                    throw new TSMBeanException("Exception creating SABean", e);
                }
                IpAppServiceAgreementManagement appSam = this.saBean.getAppServiceAgreementManagement();
                IpServiceAgreementManagement sam = null;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback");
                        logger.debug((java.lang.Object)"Interface Name = P_SERVICE_AGREEMENT_MANAGEMENT");
                    }
                    IpInterface ipInterface = this.access.obtainInterfaceWithCallback("P_SERVICE_AGREEMENT_MANAGEMENT", (IpInterface)appSam);
                    if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback");
                    }
                    sam = IpServiceAgreementManagementHelper.narrow((Object)ipInterface);
                    if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)"Narrowed IpServiceAgreementManagement");
                    }
                }
                catch (TpCommonExceptions ex) {
                    this.saBean.cleanup();
                    this.saBean = null;
                    logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback " + ex.toString()));
                    throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback", (Exception)((java.lang.Object)ex));
                }
                catch (P_ACCESS_DENIED ex) {
                    this.saBean.cleanup();
                    this.saBean = null;
                    logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback " + ex.toString()));
                    throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback", (Exception)((java.lang.Object)ex));
                }
                catch (P_INVALID_INTERFACE_NAME ex) {
                    this.saBean.cleanup();
                    this.saBean = null;
                    logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback " + ex.toString()));
                    throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback", (Exception)((java.lang.Object)ex));
                }
                catch (P_INVALID_INTERFACE_TYPE ex) {
                    this.saBean.cleanup();
                    this.saBean = null;
                    logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback " + ParlayExceptionUtil.stringify(ex)));
                    throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback", (Exception)((java.lang.Object)ex));
                }
                catch (SystemException ex) {
                    this.saBean.cleanup();
                    this.saBean = null;
                    logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback " + ex.toString()));
                    throw new TSMBeanException("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.obtainInterfaceWithCallback", (Exception)((java.lang.Object)ex));
                }
                this.saBean.setServiceAgreementManagement(sam);
            }
        } else {
            logger.warn((java.lang.Object)"Can only getSABean when in the ACTIVE_STATE state.");
            throw new IllegalStateException("Can only getSABean when in the ACTIVE_STATE state.");
        }
        return this.saBean;
    }

    public synchronized void destroySABean() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"TSMBean.destroySABean() called.");
        }
        if (this.saBean != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface");
                    logger.debug((java.lang.Object)"Interface Name = P_SERVICE_AGREEMENT_MANAGEMENT");
                }
                this.access.releaseInterface("P_SERVICE_AGREEMENT_MANAGEMENT");
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Invoked org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface");
                }
            }
            catch (TpCommonExceptions ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
            }
            catch (P_ACCESS_DENIED ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
            }
            catch (P_INVALID_INTERFACE_NAME ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
            }
            catch (SystemException ex) {
                logger.warn((java.lang.Object)("Exception invoking org::csapi::jr::fw::fwaccess::trustandsecurity::IpAccess.releaseInterface " + ex.toString()));
            }
            this.saBean.cleanup();
            this.saBean = null;
        } else if (logger.isDebugEnabled()) {
            logger.warn((java.lang.Object)"No SABean exists for this class.");
        }
    }

    public synchronized void removeTSMBeanListener(TSMBeanListener l) {
        if (this.TSMBeanListeners != null && this.TSMBeanListeners.contains(l)) {
            Vector v = (Vector)this.TSMBeanListeners.clone();
            v.removeElement(l);
            this.TSMBeanListeners = v;
        }
    }

    public synchronized void addTSMBeanListener(TSMBeanListener l) {
        Vector v;
        Vector vector = v = this.TSMBeanListeners == null ? new Vector(2) : (Vector)this.TSMBeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.TSMBeanListeners = v;
        }
    }

    public synchronized void cleanup() {
        if (!this.clean) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Cleaning up " + this.toString()));
            }
            this.tpAuthDomain = null;
            this.clientDomainID = null;
            this.state = 2;
            this.serviceDiscovery = null;
            this.initial = null;
            this.access = null;
            try {
                if (this.ipClientAPILevelAuthenticationImpl != null) {
                    ServantActivationHelper.deactivateServant((Servant)this.ipClientAPILevelAuthenticationImpl);
                    this.ipClientAPILevelAuthenticationImpl = null;
                    this.ipClientAPILevelAuthenticationPOA = null;
                    this.ipClientAPILevelAuthentication = null;
                }
                if (this.ipClientAccessImpl != null) {
                    ServantActivationHelper.deactivateServant((Servant)this.ipClientAccessImpl);
                    this.ipClientAccessImpl = null;
                }
                if (this.saBean != null) {
                    this.saBean.cleanup();
                    this.saBean = null;
                }
            }
            catch (ObjectNotActive e) {
                logger.error((java.lang.Object)"Exception deactivating callbacks", (Throwable)e);
            }
            catch (WrongPolicy e) {
                logger.error((java.lang.Object)"Exception deactivating callbacks", (Throwable)e);
            }
            catch (ServantNotActive e) {
                logger.error((java.lang.Object)"Exception deactivating callbacks", (Throwable)e);
            }
            if (this.authHandler != null) {
                this.authHandler.cleanup();
            }
            try {
                RSAUtil.saveKeyStore(this.fwProperties.getCertificateVault());
            }
            catch (RSAUtilException e) {
                logger.error((java.lang.Object)"Unable to save keyStore", (Throwable)e);
            }
            this.clean = true;
        }
    }

    public void fireTerminateAccess(TerminateAccessEvent e) {
        if (this.TSMBeanListeners != null) {
            Vector listeners = this.TSMBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((TSMBeanListener)listeners.elementAt(i)).terminateAccess(e);
                    continue;
                }
                catch (RuntimeException ex) {
                    logger.error((java.lang.Object)("Caught exception invoking application TSMBeanListener " + ex.toString()));
                }
            }
        }
    }

    public Executor getEventsQueue() {
        return this.eventsQueue;
    }

    private void traceSecurityProviders() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Installed security providers providers:");
            Provider[] aprovider = Security.getProviders();
            for (int i = 0; i < aprovider.length; ++i) {
                Provider provider = aprovider[i];
                logger.debug((java.lang.Object)("Provider " + (i + 1) + ": " + provider.getName() + "  version: " + provider.getVersion()));
            }
        }
    }

    public void setAuthenticationSequence(AuthenticationSequence newAuthenticationMechanism) throws TSMBeanException {
        if (newAuthenticationMechanism.equals(AuthenticationSequence.TWO_WAY)) {
            this.fwAuthenticationSucceeded = false;
        } else if (newAuthenticationMechanism.equals(AuthenticationSequence.ONE_WAY)) {
            this.fwAuthenticationSucceeded = true;
        } else if (newAuthenticationMechanism.equals(AuthenticationSequence.TRUSTED)) {
            this.fwAuthenticationSucceeded = false;
        } else {
            throw new TSMBeanException(newAuthenticationMechanism + " is not a valid authentication mechanism.");
        }
    }

    public FwSessionProperties getFwProperties() {
        return this.fwProperties;
    }

    public void setFwProperties(FwSessionProperties properties) {
        this.fwProperties = properties;
    }

    public ORBHandler getOrbHandler() {
        return this.orbHandler;
    }

    public void setAuthHandler(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public void setTpAuthDomain(TpAuthDomain tpAuthDomain) {
        this.tpAuthDomain = tpAuthDomain;
    }
}

